/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import java.util.Random;
import net.jitl.common.block.AncientSocketBlock;
import net.jitl.common.items.base.JItem;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class AncientPieceItem
extends JItem {
    public AncientPieceItem() {
        super(JItems.itemProps());
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        assert (player != null);
        ItemStack heldItem = player.getMainHandItem();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState blockstate = world.getBlockState(pos);
        Random itemRand = new Random();
        if (blockstate.is((Block)JBlocks.ANCIENT_SOCKET.get()) && !((Boolean)blockstate.getValue((Property)AncientSocketBlock.INSERTED)).booleanValue()) {
            BlockState blockstate1 = (BlockState)blockstate.setValue((Property)AncientSocketBlock.INSERTED, (Comparable)Boolean.TRUE);
            world.setBlock(pos, blockstate1, 2);
            heldItem.shrink(1);
            for (int i = 0; i < 16; ++i) {
                double d0 = (float)pos.getX() + (5.0f + itemRand.nextFloat() * 6.0f) / 16.0f;
                double d1 = (float)pos.getY() + 0.8125f;
                double d2 = (float)pos.getZ() + (5.0f + itemRand.nextFloat() * 6.0f) / 16.0f;
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            }
            world.playSound(null, pos, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }
}

