/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import java.util.List;
import javax.annotation.Nullable;
import net.jitl.client.ChatUtils;
import net.jitl.common.block.OkolooPedestalBlock;
import net.jitl.common.entity.boss.Blazier;
import net.jitl.common.entity.boss.Calcia;
import net.jitl.common.entity.boss.Corallator;
import net.jitl.common.entity.boss.Eudor;
import net.jitl.common.entity.boss.Logger;
import net.jitl.common.entity.boss.Scale;
import net.jitl.common.entity.boss.SentryKing;
import net.jitl.common.entity.boss.SkyStalker;
import net.jitl.common.entity.boss.SoulWatcher;
import net.jitl.common.entity.boss.TerranianProtector;
import net.jitl.common.entity.boss.ThunderBird;
import net.jitl.common.entity.boss.WitheringBeast;
import net.jitl.common.items.base.JItem;
import net.jitl.common.world.dimension.Dimensions;
import net.jitl.core.helper.LangHelper;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BossSpawnerItem
extends JItem {
    public BossSpawnerItem() {
        super(JItems.itemProps().stacksTo(1).rarity(Rarity.EPIC));
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState block = level.getBlockState(pos);
        Player player = context.getPlayer();
        if (player != null) {
            if (this == JItems.BROKEN_OKOLOO_CLUB.get()) {
                if (block == ((Block)JBlocks.OKOLOO_PEDESTAL.get()).defaultBlockState() && !((Boolean)block.getValue((Property)OkolooPedestalBlock.HAS_CLUB)).booleanValue()) {
                    BlockState filled_state = (BlockState)block.setValue((Property)OkolooPedestalBlock.HAS_CLUB, (Comparable)Boolean.TRUE);
                    level.setBlock(pos, filled_state, 2);
                    if (!player.isCreative()) {
                        player.getMainHandItem().shrink(1);
                    }
                }
            } else if (!level.isClientSide()) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.bindSpawner(player, serverLevel, pos, (Item)JItems.WITHERING_BEAST_ORB.get(), "jitl.boss_spawn.withering_beast", Dimensions.NETHER, "The Nether", (LivingEntity)new WitheringBeast((EntityType<? extends Monster>)((EntityType)JEntities.WITHERING_BEAST_TYPE.get()), level));
                this.bindSpawner(player, serverLevel, pos, (Item)JItems.CALCIA_ORB.get(), "jitl.boss_spawn.calcia", Dimensions.NETHER, "The Nether", (LivingEntity)new Calcia((EntityType<? extends Monster>)((EntityType)JEntities.CALCIA_TYPE.get()), level));
                this.bindSpawner(player, serverLevel, pos, (Item)JItems.SOUL_WATCHER_ORB.get(), "jitl.boss_spawn.soul_watcher", Dimensions.NETHER, "The Nether", (LivingEntity)new SoulWatcher((EntityType<? extends SoulWatcher>)((EntityType)JEntities.SOUL_WATCHER_TYPE.get()), level));
                this.bindSpawner(player, serverLevel, pos, (Item)JItems.BLAZIER_ORB.get(), "jitl.boss_spawn.blazier", Dimensions.NETHER, "The Nether", (LivingEntity)new Blazier((EntityType<? extends Monster>)((EntityType)JEntities.BLAZIER_TYPE.get()), level));
                this.bindSpawner(player, serverLevel, pos, (Item)JItems.EUDOR_CROWN.get(), "jitl.boss_spawn.eudor", Dimensions.EUCA, "Euca", (LivingEntity)new Eudor((EntityType<? extends Monster>)((EntityType)JEntities.EUDOR_TYPE.get()), level));
                this.bindSpawner(player, serverLevel, pos, (Item)JItems.CORALLATOR_ORB.get(), "jitl.boss_spawn.corallator", Dimensions.EUCA, "Euca", (LivingEntity)new Corallator((EntityType<? extends Corallator>)((EntityType)JEntities.CORALLATOR_TYPE.get()), level));
                this.bindSpawner(player, serverLevel, pos, (Item)JItems.THUNDER_BIRD_ORB.get(), "jitl.boss_spawn.thunder_bird", Dimensions.DEPTHS, "The Depths", (LivingEntity)new ThunderBird((EntityType<? extends Monster>)((EntityType)JEntities.THUNDER_BIRD_TYPE.get()), level));
                this.bindSpawner(player, serverLevel, pos, (Item)JItems.SCALE_ORB.get(), "jitl.boss_spawn.scale", Dimensions.DEPTHS, "The Depths", (LivingEntity)new Scale((EntityType<? extends Scale>)((EntityType)JEntities.SCALE_TYPE.get()), level));
                this.bindSpawner(player, serverLevel, pos, (Item)JItems.LOGGER_ORB.get(), "jitl.boss_spawn.logger", Dimensions.CORBA, "Corba", (LivingEntity)new Logger((EntityType<? extends Monster>)((EntityType)JEntities.LOGGER_TYPE.get()), level));
                this.bindSpawner(player, serverLevel, pos, (Item)JItems.SENTRY_KING_ORB.get(), "jitl.boss_spawn.sentry_king", Dimensions.CORBA, "Corba", (LivingEntity)new SentryKing((EntityType<? extends SentryKing>)((EntityType)JEntities.SENTRY_KING_TYPE.get()), level));
                this.bindSpawner(player, serverLevel, pos, (Item)JItems.ENCHANTED_TERRASTAR.get(), "jitl.boss_spawn.terranian_protector", Dimensions.TERRANIA, "Terrania", (LivingEntity)new TerranianProtector((EntityType<? extends TerranianProtector>)((EntityType)JEntities.TERRANIAN_PROTECTOR_TYPE.get()), level));
                this.bindSpawner(player, serverLevel, pos, (Item)JItems.MYSTERIOUS_DISK.get(), "jitl.boss_spawn.sky_stalker", Dimensions.CLOUDIA, "Cloudia", (LivingEntity)new SkyStalker((EntityType<? extends SkyStalker>)((EntityType)JEntities.SKY_STALKER_TYPE.get()), level));
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public void bindSpawner(Player player, ServerLevel level, BlockPos pos, Item spawner, String langKey, ResourceKey<Level> dimension, String dimensionName, LivingEntity boss) {
        if (player.getMainHandItem().getItem() == spawner && boss != null) {
            if (level.getLevel() == level.getServer().getLevel(dimension)) {
                boss.setPos((double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ());
                level.addFreshEntity((Entity)boss);
                if (!player.isCreative()) {
                    player.getMainHandItem().shrink(1);
                }
                ChatUtils.sendColouredTranslatedMessage(player, ChatFormatting.GOLD, langKey, new Object[0]);
            } else {
                ChatUtils.sendColouredTranslatedMessage(player, ChatFormatting.RED, "jitl.boss_spawn.fail", boss.getName(), dimensionName);
            }
        }
    }

    @Override
    public void appendHoverText(@NotNull ItemStack pStack, @Nullable Item.TooltipContext con, @NotNull List<Component> tip, @NotNull TooltipFlag pFlag) {
        if (this == JItems.BROKEN_OKOLOO_CLUB.get()) {
            tip.add((Component)Component.translatable((String)"jitl.tooltip.okoloo"));
        }
        if (this == JItems.WITHERING_BEAST_ORB.get()) {
            tip.add((Component)LangHelper.setBossSpawner("Withering Beast"));
        }
        if (this == JItems.CALCIA_ORB.get()) {
            tip.add((Component)LangHelper.setBossSpawner("Calcia"));
        }
        if (this == JItems.SOUL_WATCHER_ORB.get()) {
            tip.add((Component)LangHelper.setBossSpawner("Soul Watcher"));
        }
        if (this == JItems.BLAZIER_ORB.get()) {
            tip.add((Component)LangHelper.setBossSpawner("Blazier"));
        }
        if (this == JItems.EUDOR_CROWN.get()) {
            tip.add((Component)LangHelper.setBossSpawner("Eudor"));
        }
        if (this == JItems.CORALLATOR_ORB.get()) {
            tip.add((Component)LangHelper.setBossSpawner("Corallator"));
        }
        if (this == JItems.THUNDER_BIRD_ORB.get()) {
            tip.add((Component)LangHelper.setBossSpawner("Thunderbird"));
        }
        if (this == JItems.SCALE_ORB.get()) {
            tip.add((Component)LangHelper.setBossSpawner("Scale"));
        }
        if (this == JItems.LOGGER_ORB.get()) {
            tip.add((Component)LangHelper.setBossSpawner("Logger"));
        }
        if (this == JItems.SENTRY_KING_ORB.get()) {
            tip.add((Component)LangHelper.setBossSpawner("Sentry King"));
        }
        if (this == JItems.ENCHANTED_TERRASTAR.get()) {
            tip.add((Component)LangHelper.setBossSpawner("Terranian Protector"));
        }
        if (this == JItems.MYSTERIOUS_DISK.get()) {
            tip.add((Component)LangHelper.setBossSpawner("Sky Stalker"));
        }
    }
}

