/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import net.jitl.common.block.portal.JBasePortalBlock;
import net.jitl.common.block.portal.logic.JPortalShape;
import net.jitl.common.items.base.JItem;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class FlameCoinItem
extends JItem {
    public FlameCoinItem() {
        super(JItems.itemProps().durability(100));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        Player player = context.getPlayer();
        if (!context.getLevel().isClientSide && player != null) {
            for (Direction direction : Direction.Plane.VERTICAL) {
                BlockPos blockpos = context.getClickedPos();
                BlockState blockstate = world.getBlockState(blockpos);
                if (blockstate.getBlock() == JBlocks.EUCA_PORTAL_FRAME.get() && context.getClickedFace() == Direction.UP) {
                    JPortalShape.PortalDirection facing = JPortalShape.testFrameForActivation(world, blockpos, direction, (JBasePortalBlock)JBlocks.EUCA_PORTAL.get(), (Block)JBlocks.EUCA_PORTAL_FRAME.get());
                    if (world instanceof ServerLevel) {
                        ServerLevel level = (ServerLevel)world;
                        JPortalShape.lightPortalFrame(level, blockpos, facing, (JBasePortalBlock)JBlocks.EUCA_PORTAL.get());
                    }
                    return InteractionResult.CONSUME;
                }
                if (blockstate.getBlock() == JBlocks.FROZEN_PORTAL_FRAME.get() && context.getClickedFace() == Direction.UP) {
                    JPortalShape.PortalDirection facing = JPortalShape.testFrameForActivation(world, blockpos, direction, (JBasePortalBlock)JBlocks.FROZEN_PORTAL.get(), (Block)JBlocks.FROZEN_PORTAL_FRAME.get());
                    if (world instanceof ServerLevel) {
                        ServerLevel level = (ServerLevel)world;
                        JPortalShape.lightPortalFrame(level, blockpos, facing, (JBasePortalBlock)JBlocks.FROZEN_PORTAL.get());
                    }
                    return InteractionResult.CONSUME;
                }
                if (blockstate.getBlock() == JBlocks.BOIL_PORTAL_FRAME.get() && context.getClickedFace() == Direction.UP) {
                    JPortalShape.PortalDirection facing = JPortalShape.testFrameForActivation(world, blockpos, direction, (JBasePortalBlock)JBlocks.BOIL_PORTAL.get(), (Block)JBlocks.BOIL_PORTAL_FRAME.get());
                    if (world instanceof ServerLevel) {
                        ServerLevel level = (ServerLevel)world;
                        JPortalShape.lightPortalFrame(level, blockpos, facing, (JBasePortalBlock)JBlocks.BOIL_PORTAL.get());
                    }
                    return InteractionResult.CONSUME;
                }
                if (blockstate.getBlock() == JBlocks.TERRANIAN_PORTAL_FRAME.get() && context.getClickedFace() == Direction.UP) {
                    JPortalShape.PortalDirection facing = JPortalShape.testFrameForActivation(world, blockpos, direction, (JBasePortalBlock)JBlocks.TERRANIAN_PORTAL.get(), (Block)JBlocks.TERRANIAN_PORTAL_FRAME.get());
                    if (world instanceof ServerLevel) {
                        ServerLevel level = (ServerLevel)world;
                        JPortalShape.lightPortalFrame(level, blockpos, facing, (JBasePortalBlock)JBlocks.TERRANIAN_PORTAL.get());
                    }
                    return InteractionResult.CONSUME;
                }
                if (blockstate.getBlock() != JBlocks.CLOUDIA_PORTAL_FRAME.get() || context.getClickedFace() != Direction.UP) continue;
                JPortalShape.PortalDirection facing = JPortalShape.testFrameForActivation(world, blockpos, direction, (JBasePortalBlock)JBlocks.CLOUDIA_PORTAL.get(), (Block)JBlocks.CLOUDIA_PORTAL_FRAME.get());
                if (world instanceof ServerLevel) {
                    ServerLevel level = (ServerLevel)world;
                    JPortalShape.lightPortalFrame(level, blockpos, facing, (JBasePortalBlock)JBlocks.CLOUDIA_PORTAL.get());
                }
                return InteractionResult.CONSUME;
            }
            if (!player.isCreative()) {
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
            }
        }
        return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
    }
}

