/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import java.util.List;
import net.jitl.common.capability.essence.PlayerEssence;
import net.jitl.common.entity.projectile.JThrowableProjectile;
import net.jitl.common.items.base.JSwordItem;
import net.jitl.core.helper.IEssenceItem;
import net.jitl.core.helper.JToolTiers;
import net.jitl.core.helper.TriFunction;
import net.jitl.core.init.internal.JDataAttachments;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class HammerItem
extends JSwordItem
implements IEssenceItem {
    protected TriFunction<Integer, Level, LivingEntity, JThrowableProjectile> projectileFactory;
    private final int essenceUsage;
    private final int damage;

    public HammerItem(JToolTiers tier, int essence, int damage, TriFunction<Integer, Level, LivingEntity, JThrowableProjectile> projectileFactory) {
        super(tier, JItems.BASIC, JItems.itemProps().attributes(HammerItem.createAttributes((Tier)tier.getTier(), (int)tier.getDamage(), (float)tier.getSpeedModifier())).durability(tier.getTier().getUses()));
        this.projectileFactory = projectileFactory;
        this.essenceUsage = essence;
        this.damage = damage;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (!level.isClientSide() && ((PlayerEssence)player.getData(JDataAttachments.ESSENCE)).consumeEssence(player, this.essenceUsage)) {
            JThrowableProjectile projectile = this.projectileFactory.apply(this.damage, level, (LivingEntity)player);
            projectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)projectile);
            player.getItemInHand(usedHand).hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)JSounds.HAMMER.get(), SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag pTooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"jitl.tooltip.hammer", (Object[])new Object[]{this.damage / 2}));
        this.addItemDesc(JItems.SPELLBINDING_HAMMER.asItem(), tooltip, "jitl.tooltip.spellbinding_hammer");
        this.addItemDesc(JItems.EARTHEN_HAMMER.asItem(), tooltip, "jitl.tooltip.earthen_hammer");
        this.addItemDesc(JItems.FLAMING_HAMMER.asItem(), tooltip, "jitl.tooltip.flaming_hammer");
        this.addItemDesc(JItems.NETHIC_HAMMER.asItem(), tooltip, "jitl.tooltip.nethic_hammer");
        this.addItemDesc(JItems.OVERGROWN_HAMMER.asItem(), tooltip, "jitl.tooltip.overgrown_hammer");
        this.addItemDesc(JItems.ROCKY_HAMMER.asItem(), tooltip, "jitl.tooltip.rocky_hammer");
        this.addItemDesc(JItems.ROYAL_HAMMER.asItem(), tooltip, "jitl.tooltip.royal_hammer");
        this.addItemDesc(JItems.CRYSTALLIZED_HAMMER.asItem(), tooltip, "jitl.tooltip.crystallized_hammer");
        this.addItemDesc(JItems.WITHIC_HAMMER.asItem(), tooltip, "jitl.tooltip.withic_hammer");
        tooltip.add((Component)Component.translatable((String)"jitl.tooltip.essence_usage", (Object[])new Object[]{this.essenceUsage}));
        tooltip.add((Component)Component.translatable((String)"jitl.uses_remaining", (Object[])new Object[]{stack.getMaxDamage() - stack.getDamageValue()}));
    }

    public void addItemDesc(Item item, List<Component> tooltip, String descLoc) {
        if (this == item) {
            tooltip.add((Component)Component.translatable((String)descLoc));
        }
    }
}

