/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import java.util.List;
import net.jitl.common.items.base.JItem;
import net.jitl.core.helper.IEssenceItem;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class HealingItem
extends JItem
implements IEssenceItem {
    public float amount = 0.0f;

    public HealingItem(float amount) {
        super(JItems.itemProps().stacksTo(1).durability(1));
        this.amount = amount;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, @NotNull Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            player.heal(this.amount == -1.0f ? player.getMaxHealth() : this.amount);
            player.getItemInHand(hand).shrink(1);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        world.playSound(player, player.getOnPos(), (SoundEvent)JSounds.STAFF_0.get(), SoundSource.BLOCKS);
        return InteractionResultHolder.fail((Object)itemstack);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag pTooltipFlag) {
        if (this.amount == -1.0f) {
            tooltip.add((Component)Component.translatable((String)"jitl.item.desc.full_health"));
        } else {
            tooltip.add((Component)Component.literal((String)("Restores " + this.amount + " health")));
        }
    }
}

