/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import net.jitl.client.ChatUtils;
import net.jitl.common.capability.essence.PlayerEssence;
import net.jitl.common.items.base.JItem;
import net.jitl.core.helper.IEssenceItem;
import net.jitl.core.init.internal.JDataAttachments;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;

public class MinersPearl
extends JItem
implements IEssenceItem {
    public MinersPearl(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            boolean canUse;
            Player player = (Player)entity;
            PlayerEssence essence = (PlayerEssence)player.getData(JDataAttachments.ESSENCE);
            boolean bl = canUse = player.getY() <= (double)(world.getSeaLevel() - 2) && !world.canSeeSky(new BlockPos((int)player.getX(), (int)(player.getY() + (double)player.getEyeHeight()), (int)player.getZ())) && !player.isInWater();
            if (canUse) {
                if (!world.isClientSide) {
                    player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 2));
                    if (essence.consumeEssence(player, 10.0f)) {
                        player.teleportTo((double)player.getBlockX(), (double)world.getHeight(Heightmap.Types.WORLD_SURFACE, (int)player.getX(), (int)player.getZ()), (double)player.getBlockZ());
                        stack.hurtAndBreak(1, (ServerLevel)player.level(), (LivingEntity)player, item -> {});
                    }
                } else {
                    world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.PORTAL_TRIGGER, SoundSource.BLOCKS);
                }
            } else if (world.isClientSide) {
                world.playSound(player, player.getX(), player.getY(), player.getZ(), (SoundEvent)JSounds.STAFF_0.get(), SoundSource.BLOCKS);
                ChatUtils.sendColouredTranslatedMessage(player, ChatFormatting.DARK_PURPLE, "jitl.message.item.miners_pearl", new Object[0]);
            }
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }
}

