/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import java.util.List;
import javax.annotation.Nullable;
import net.jitl.common.entity.base.JTamableEntity;
import net.jitl.common.entity.overworld.PetRobot;
import net.jitl.common.items.base.JItem;
import net.jitl.core.helper.LangHelper;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PetSpawnerItem
extends JItem {
    public PetSpawnerItem() {
        super(JItems.itemProps().stacksTo(1).rarity(Rarity.RARE));
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (player != null && !level.isClientSide()) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.bindSpawner(player, serverLevel, pos, (Item)JItems.PET_ROBOT_SPAWNER.get(), (LivingEntity)new PetRobot((EntityType<? extends JTamableEntity>)((EntityType)JEntities.PET_ROBOT_TYPE.get()), level, player));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public void bindSpawner(Player player, ServerLevel level, BlockPos pos, Item spawner, LivingEntity pet) {
        if (player.getMainHandItem().getItem() == spawner && pet != null) {
            pet.setPos((double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ());
            level.addFreshEntity((Entity)pet);
            if (!player.isCreative()) {
                player.getMainHandItem().shrink(1);
            }
        }
    }

    @Override
    public void appendHoverText(@NotNull ItemStack pStack, @Nullable Item.TooltipContext con, @NotNull List<Component> tip, @NotNull TooltipFlag pFlag) {
        if (this == JItems.PET_ROBOT_SPAWNER.get()) {
            tip.add((Component)LangHelper.setPetSpawner("Robot"));
        }
    }
}

