/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items;

import net.jitl.common.entity.projectile.PiercerEntity;
import net.jitl.common.items.base.JItem;
import net.jitl.core.helper.JEnchantmentHelper;
import net.jitl.core.init.internal.JEnchantments;
import net.jitl.core.init.internal.JItems;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PiercerItem
extends JItem {
    public final int maxBounces;
    public final float damage;

    public PiercerItem(int maxBounces, float damage) {
        super(JItems.itemProps().stacksTo(8));
        this.maxBounces = maxBounces;
        this.damage = damage;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        worldIn.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.ENDER_PEARL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (worldIn.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!worldIn.isClientSide()) {
            int faithfulLevel;
            int scorchingLevel;
            int ambitLevel;
            int lightweightLevel;
            PiercerEntity entity = new PiercerEntity((LivingEntity)playerIn, worldIn, stack, this.maxBounces, this.damage, stack);
            ServerLevel serverLevel = (ServerLevel)worldIn;
            int sharpnessLevel = JEnchantmentHelper.getEnchantmentAmount(playerIn, serverLevel, JEnchantments.RAZOR);
            if (sharpnessLevel > 0) {
                entity.setBaseDamage(entity.getBaseDamage() + (double)sharpnessLevel * 0.5 + 0.5);
            }
            if ((lightweightLevel = JEnchantmentHelper.getEnchantmentAmount(playerIn, serverLevel, JEnchantments.LIGHTWEIGHT)) > 0) {
                entity.setVelocityMultiplier(lightweightLevel);
            }
            if ((ambitLevel = JEnchantmentHelper.getEnchantmentAmount(playerIn, serverLevel, JEnchantments.AMBIT)) > 0) {
                entity.setRangeAddend(ambitLevel * 4);
            }
            if ((scorchingLevel = JEnchantmentHelper.getEnchantmentAmount(playerIn, serverLevel, JEnchantments.SCORCHING)) > 0) {
                entity.setFlameAddend(scorchingLevel);
            }
            if ((faithfulLevel = JEnchantmentHelper.getEnchantmentAmount(playerIn, serverLevel, JEnchantments.FAITHFUL)) > 0) {
                entity.setFaithfulLevel(faithfulLevel);
            }
            entity.setPos(playerIn.getX(), playerIn.getEyeY(), playerIn.getZ());
            entity.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.0f, 1.5f, 1.0f);
            if (playerIn.isCreative()) {
                entity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            } else {
                playerIn.getInventory().removeItem(stack);
            }
            worldIn.addFreshEntity((Entity)entity);
            playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)worldIn.isClientSide());
    }

    public int getEnchantmentValue(@NotNull ItemStack stack) {
        return 30;
    }

    public boolean isEnchantable(@NotNull ItemStack pStack) {
        return true;
    }
}

