/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items.base;

import java.util.List;
import net.jitl.common.items.gear.IAbility;
import net.jitl.common.items.gear.JGear;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JArmorItem
extends ArmorItem
implements JGear {
    private final IAbility ability;

    public JArmorItem(Holder<ArmorMaterial> pMaterial, ArmorItem.Type pSlot, IAbility ability) {
        super(pMaterial, pSlot, JItems.itemProps().stacksTo(1));
        this.ability = ability;
    }

    @Override
    @Nullable
    public IAbility getAbility() {
        if (this.ability == null) {
            return new IAbility(this){};
        }
        return this.ability;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag pTooltipFlag) {
        super.appendHoverText(stack, pContext, tooltip, pTooltipFlag);
        if (this.ability != null) {
            this.ability.fillTooltips(stack, tooltip);
        }
    }

    public int getEnchantmentValue(@NotNull ItemStack stack) {
        return 30;
    }

    public boolean isEnchantable(@NotNull ItemStack pStack) {
        return true;
    }
}

