/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items.base;

import net.jitl.client.render.item.JShieldRenderer;
import net.jitl.core.init.JITL;
import net.jitl.core.init.internal.JItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class JShieldItem
extends ShieldItem {
    public final ResourceLocation texture;
    private final Ingredient repairItem;

    public JShieldItem(String name, int uses, Item repairItem) {
        super(JItems.itemProps().durability(uses));
        this.repairItem = Ingredient.of((ItemLike[])new ItemLike[]{repairItem});
        this.texture = JITL.rl("textures/shield/" + name + "_shield.png");
    }

    public boolean isValidRepairItem(@NotNull ItemStack shield, @NotNull ItemStack repair) {
        if (this.repairItem != null) {
            return this.repairItem.test(repair) || super.isValidRepairItem(shield, repair);
        }
        return false;
    }

    public static class RenderProps
    implements IClientItemExtensions {
        public static RenderProps INSTANCE = new RenderProps();

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return new JShieldRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
        }
    }
}

