/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.items.curios.ring;

import net.jitl.common.capability.player.ItemCooldown;
import net.jitl.common.items.curios.JCurioItem;
import net.jitl.core.init.internal.JDataAttachments;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;

public class JRingItem
extends JCurioItem {
    private Holder<MobEffect> potion;

    public JRingItem(Item.Properties properties) {
        super(properties);
    }

    public JRingItem effect(Holder<MobEffect> effectSupplier) {
        this.potion = effectSupplier;
        return this;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemCooldown curios = (ItemCooldown)slotContext.entity().getData(JDataAttachments.ITEM_COOLDOWN);
            if (!player.level().isClientSide()) {
                int cooldown = curios.getCooldown();
                if (cooldown == 0) {
                    if (player.hasEffect(this.potion)) {
                        player.removeEffect(this.potion);
                        curios.setCooldown(400);
                    }
                } else {
                    curios.setCooldown(Math.max(0, cooldown - (player.hasEffect(this.potion) ? 1 : 4)));
                }
                curios.sendPacket(player);
            }
        }
    }
}

