/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.scroll;

import java.util.List;
import java.util.Objects;
import net.jitl.client.util.EnumHexColor;
import net.jitl.common.scroll.IDescComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class TextDescComponent
implements IDescComponent {
    private final String langKey;
    private int contentHeight;
    private List<FormattedCharSequence> wrappedText;

    public TextDescComponent(String langKey) {
        this.langKey = langKey;
    }

    @Override
    public int getContentPartHeight() {
        return this.contentHeight + 5;
    }

    @Override
    public void drawContentPart(GuiGraphics matrixStack, int x0, int y0, int width) {
        int i = y0;
        for (FormattedCharSequence s : this.wrappedText) {
            matrixStack.drawString(Minecraft.getInstance().font, s, x0, i, EnumHexColor.DARK_BROWN.getInt(), false);
            Objects.requireNonNull(Minecraft.getInstance().font);
            i += 9;
        }
    }

    @Override
    public void determineContentPartHeight(int width) {
        this.wrappedText = Minecraft.getInstance().font.split((FormattedText)Component.translatable((String)String.valueOf(this.langKey)), width);
        Objects.requireNonNull(Minecraft.getInstance().font);
        this.contentHeight = 9 * this.wrappedText.size();
    }
}

