/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world;

import java.util.Objects;
import net.jitl.common.capability.essence.PlayerEssence;
import net.jitl.common.capability.gear.PlayerArmor;
import net.jitl.common.capability.keypressed.PressedKeyCap;
import net.jitl.common.capability.player.CelestiumArmorAbility;
import net.jitl.common.capability.player.ItemCooldown;
import net.jitl.common.capability.player.Portal;
import net.jitl.common.capability.stats.PlayerStats;
import net.jitl.core.init.internal.JAttributes;
import net.jitl.core.init.internal.JDataAttachments;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="jitl", bus=EventBusSubscriber.Bus.GAME)
public class ModEvents {
    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            ((PlayerStats)event.getEntity().getData(JDataAttachments.PLAYER_STATS)).copyFrom((PlayerStats)event.getOriginal().getData(JDataAttachments.PLAYER_STATS));
            ((PlayerEssence)event.getEntity().getData(JDataAttachments.ESSENCE)).copyFrom((PlayerEssence)event.getOriginal().getData(JDataAttachments.ESSENCE));
            ((PressedKeyCap)event.getEntity().getData(JDataAttachments.KEY_PRESSED)).copyFrom((PressedKeyCap)event.getOriginal().getData(JDataAttachments.KEY_PRESSED));
            ((PlayerArmor)event.getEntity().getData(JDataAttachments.PLAYER_ARMOR)).copyFrom((PlayerArmor)event.getOriginal().getData(JDataAttachments.PLAYER_ARMOR));
            ((Portal)event.getEntity().getData(JDataAttachments.PORTAL_OVERLAY)).copyFrom((Portal)event.getOriginal().getData(JDataAttachments.PORTAL_OVERLAY));
            ((CelestiumArmorAbility)event.getEntity().getData(JDataAttachments.CELESTIUM_ARMOR)).copyFrom((CelestiumArmorAbility)event.getOriginal().getData(JDataAttachments.CELESTIUM_ARMOR));
            ((ItemCooldown)event.getEntity().getData(JDataAttachments.ITEM_COOLDOWN)).copyFrom((ItemCooldown)event.getOriginal().getData(JDataAttachments.ITEM_COOLDOWN));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof Player) {
            Player player2 = player;
            PlayerStats stats = (PlayerStats)player2.getData(JDataAttachments.PLAYER_STATS);
            stats.update(player2);
            Portal portal = (Portal)player2.getData(JDataAttachments.PORTAL_OVERLAY);
            portal.serverTick();
            PlayerEssence essence = (PlayerEssence)player2.getData(JDataAttachments.ESSENCE);
            if (essence.isRegenReady()) {
                essence.addEssence(player2, (float)Objects.requireNonNull(player2.getAttribute(JAttributes.ESSENCE_REGEN_SPEED)).getValue());
            } else {
                essence.setBurnout(essence.getBurnout() - 0.1f);
            }
            essence.sendPacket(player2);
        }
    }
}

