/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CaveWorldCarver;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class BoilCaveCarver
extends CaveWorldCarver {
    public BoilCaveCarver(Codec<CaveCarverConfiguration> codec_) {
        super(codec_);
        this.liquids = ImmutableSet.of((Object)Fluids.LAVA, (Object)Fluids.WATER);
    }

    protected int getCaveBound() {
        return 15;
    }

    protected float getThickness(RandomSource random) {
        return (random.nextFloat() * 3.0f + random.nextFloat()) * 3.0f;
    }

    protected double getYScale() {
        return 2.0;
    }

    protected boolean carveBlock(CarvingContext carv, CaveCarverConfiguration config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> func, CarvingMask mask, BlockPos.MutableBlockPos pos, BlockPos.MutableBlockPos pos2, Aquifer a, MutableBoolean mut) {
        if (this.canReplaceBlock((CarverConfiguration)config, chunk.getBlockState((BlockPos)pos))) {
            BlockState blockstate = pos.getY() <= carv.getMinGenY() + 31 ? LAVA.createLegacyBlock() : CAVE_AIR;
            chunk.setBlockState((BlockPos)pos, blockstate, false);
            return true;
        }
        return false;
    }
}

