/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.depths;

import com.mojang.serialization.Codec;
import net.jitl.common.block.base.AttachedBlock;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DepthsCrystalFeature
extends Feature<NoneFeatureConfiguration> {
    public DepthsCrystalFeature(Codec<NoneFeatureConfiguration> codec_) {
        super(codec_);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos1 = context.origin();
        WorldGenLevel reader = context.level();
        RandomSource rand = context.random();
        if (reader.getBlockState(pos1.below()) != ((Block)JBlocks.DEPTHS_STONE.get()).defaultBlockState()) {
            return false;
        }
        int i = rand.nextInt(20) + 5;
        int j = i / 4 + rand.nextInt(2);
        for (int k = 0; k < i; ++k) {
            float f = (1.0f - (float)k / (float)i) * (float)j;
            int l = Mth.ceil((float)f);
            for (int i1 = -l; i1 <= l; ++i1) {
                float f1 = (float)Mth.abs((int)i1) - 0.5f;
                for (int j1 = -l; j1 <= l; ++j1) {
                    float f2 = (float)Mth.abs((int)j1) - 0.5f;
                    if ((i1 != 0 || j1 != 0) && f1 * f1 + f2 * f2 > f * f || (i1 == -l || i1 == l || j1 == -l || j1 == l) && rand.nextFloat() > 0.75f) continue;
                    BlockState blockstate = reader.getBlockState(pos1.offset(i1, k, j1));
                    BlockState above = reader.getBlockState(pos1.offset(i1, k + 1, j1));
                    if (!blockstate.isAir() || above != ((Block)JBlocks.DEPTHS_STONE.get()).defaultBlockState() || rand.nextInt(4) != 0) continue;
                    this.setBlock((LevelWriter)reader, pos1.offset(i1, k, j1), (BlockState)((Block)JBlocks.DEPTHS_CRYSTAL.get()).defaultBlockState().setValue((Property)AttachedBlock.FACING, (Comparable)Direction.DOWN));
                }
            }
        }
        return true;
    }
}

