/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.ruins;

import com.mojang.serialization.Codec;
import net.jitl.common.block.JChestBlock;
import net.jitl.common.world.gen.ruins.RuinsFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class RuinsFeature
extends Feature<RuinsFeatureConfig> {
    public RuinsFeature(Codec<RuinsFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RuinsFeatureConfig> context) {
        BlockPos pos = context.origin();
        WorldGenLevel reader = context.level();
        RandomSource rand = context.random();
        RuinsFeatureConfig config = (RuinsFeatureConfig)context.config();
        if (!config.spawnBlock.test(reader.getBlockState(pos.below()), rand)) {
            return false;
        }
        BlockPos.MutableBlockPos placePos = pos.mutable();
        int columns = rand.nextInt(config.maxColumns) + 5;
        for (int j1 = 0; j1 < columns; ++j1) {
            int xPos = pos.getX() + rand.nextInt(config.maxSpreading);
            int zPos = pos.getZ() + rand.nextInt(config.maxSpreading);
            int yPos = reader.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, xPos, zPos);
            int height = 1 + rand.nextInt(config.maxHeight);
            placePos.set(xPos, yPos, zPos);
            if (config.spawnBlock.test(reader.getBlockState(placePos.below()), rand)) {
                for (int i = 0; i < height; ++i) {
                    reader.setBlock((BlockPos)placePos, config.ruinedBlocksProvider.getState(rand, (BlockPos)placePos), 2);
                    placePos.move(Direction.UP);
                }
            }
            if (rand.nextInt(4) != 0) continue;
            BlockPos chestPos = new BlockPos(pos.getX(), yPos - 2, pos.getZ());
            BlockPos spawnPos = new BlockPos(pos.getX(), yPos, pos.getZ());
            if (!config.spawnBlock.test(reader.getBlockState(spawnPos.below()), rand)) continue;
            BlockState chestState = (BlockState)config.chest.getState(rand, chestPos).setValue((Property)JChestBlock.FACING, (Comparable)Direction.Plane.HORIZONTAL.getRandomDirection(rand));
            reader.setBlock(chestPos, chestState, 2);
            if (!(reader.getBlockEntity(chestPos) instanceof ChestBlockEntity)) continue;
        }
        return true;
    }
}

