/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.jitl.core.init.internal.StructureRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public final class LowestGroundType
extends Structure {
    public static final MapCodec<LowestGroundType> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LowestGroundType.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.fieldOf("min_height").forGetter(structure -> structure.minHeight), (App)Codec.INT.fieldOf("max_height").forGetter(structure -> structure.maxHeight), (App)Codec.INT.fieldOf("bury").forGetter(structure -> structure.bury), (App)Codec.STRING.optionalFieldOf("mode", (Object)"full").forGetter(structure -> structure.mode), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, LowestGroundType::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final String mode;
    private final int size;
    private final int minHeight;
    private final int maxHeight;
    private final int bury;
    private final int maxDistanceFromCenter;

    public LowestGroundType(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, int minHeight, int maxHeight, int bury, String mode, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.bury = bury;
        this.mode = mode;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        int y;
        WorldgenRandom worldgenrandom = context.random();
        int x = context.chunkPos().getMinBlockX() + worldgenrandom.nextInt(16);
        int z = context.chunkPos().getMinBlockZ() + worldgenrandom.nextInt(16);
        NoiseColumn column = context.chunkGenerator().getBaseColumn(x, z, context.heightAccessor(), context.randomState());
        int maxY = this.mode.equals("random_section") ? context.random().nextInt(this.minHeight, this.maxHeight + 1) : this.maxHeight;
        int n = y = this.mode.equals("full") ? this.minHeight : context.random().nextInt(this.minHeight, maxY + 1);
        if (column.getBlock(y).isAir()) {
            while (++y < maxY + 2 && column.getBlock(y).isAir()) {
            }
        }
        while (y < maxY + 2 && !column.getBlock(y).isAir()) {
            ++y;
        }
        if (y > maxY) {
            return Optional.empty();
        }
        Optional structurePiecesGenerator = JigsawPlacement.addPieces((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)new BlockPos(x, y -= this.bury, z), (boolean)false, Optional.empty(), (int)this.maxDistanceFromCenter, (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)DimensionPadding.ZERO, (LiquidSettings)LiquidSettings.APPLY_WATERLOGGING);
        return structurePiecesGenerator;
    }

    public StructureType<?> type() {
        return (StructureType)StructureRegistry.LOWEST_GROUND.get();
    }
}

