/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.terrania;

import com.mojang.serialization.MapCodec;
import net.jitl.common.world.gen.JTreeDecorators;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.jetbrains.annotations.NotNull;

public class TerranianTrunkVineDecorator
extends TreeDecorator {
    public static final MapCodec<TerranianTrunkVineDecorator> CODEC = MapCodec.unit(() -> INSTANCE);
    public static final TerranianTrunkVineDecorator INSTANCE = new TerranianTrunkVineDecorator();

    @NotNull
    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)JTreeDecorators.TERRANIAN_TRUNK_DECORATOR.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource randomsource = context.random();
        context.logs().forEach(d -> {
            BlockPos blockpos3;
            BlockPos blockpos2;
            BlockPos blockpos1;
            BlockPos blockpos;
            if (randomsource.nextInt(3) > 0 && context.isAir(blockpos = d.west())) {
                this.placeVine(context, blockpos, VineBlock.EAST);
            }
            if (randomsource.nextInt(3) > 0 && context.isAir(blockpos1 = d.east())) {
                this.placeVine(context, blockpos1, VineBlock.WEST);
            }
            if (randomsource.nextInt(3) > 0 && context.isAir(blockpos2 = d.north())) {
                this.placeVine(context, blockpos2, VineBlock.SOUTH);
            }
            if (randomsource.nextInt(3) > 0 && context.isAir(blockpos3 = d.south())) {
                this.placeVine(context, blockpos3, VineBlock.NORTH);
            }
        });
    }

    public void placeVine(TreeDecorator.Context c, BlockPos p, BooleanProperty s) {
        c.setBlock(p, (BlockState)((Block)JBlocks.TERRANIAN_VINE.get()).defaultBlockState().setValue((Property)s, (Comparable)Boolean.TRUE));
    }
}

