/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.tree_grower;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.jitl.common.world.gen.tree_grower.TreeConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import org.jetbrains.annotations.NotNull;

public class JourneyTree
extends Feature<TreeConfig> {
    public JourneyTree() {
        super(TreeConfig.CODEC);
    }

    public boolean hasSpace(WorldGenLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return this.hasSpace(state);
    }

    public boolean hasSpace(BlockState state) {
        return state.isAir() || state.is(BlockTags.LEAVES) || state.is(BlockTags.FLOWERS);
    }

    public boolean canBeHere(WorldGenLevel level, BlockPos pos) {
        if (this.hasSpace(level, pos)) {
            BlockState state = level.getBlockState(pos.below());
            return this.defaultGrowOn(state) && level.getBlockState(pos).isAir() && level.getBlockState(pos) != Blocks.LAVA.defaultBlockState() && state != Blocks.LAVA.defaultBlockState();
        }
        return false;
    }

    private static boolean isVine(LevelSimulatedReader l, BlockPos p) {
        return l.isStateAtPosition(p, s -> s.is(Blocks.VINE));
    }

    private static void setBlockKnownShape(LevelWriter l, BlockPos p, BlockState s) {
        l.setBlock(p, s, 19);
    }

    protected boolean defaultGrowOn(BlockState state) {
        return state.is(BlockTags.DIRT);
    }

    protected void setBlock(WorldGenLevel level, BlockPos pos, BlockState state, boolean replace) {
        BlockState block = level.getBlockState(pos);
        if (this.hasSpace(block) || replace && !block.is(Blocks.BEDROCK)) {
            this.setBlock((LevelWriter)level, pos, state);
        }
    }

    private boolean doPlace(WorldGenLevel level, RandomSource random, BlockPos pos, BiConsumer<BlockPos, BlockState> root, BiConsumer<BlockPos, BlockState> trunk, FoliagePlacer.FoliageSetter foiliage, TreeConfig config) {
        if (this.canBeHere(level, pos)) {
            int i = config.trunkPlacer.getTreeHeight(random);
            int j = config.foliagePlacer.foliageHeight(random, i, (TreeConfiguration)config);
            int k = i - j;
            int l = config.foliagePlacer.foliageRadius(random, k);
            BlockPos blockpos = config.rootPlacer.map(p_225286_ -> p_225286_.getTrunkOrigin(pos, random)).orElse(pos);
            int i1 = Math.min(pos.getY(), blockpos.getY());
            int j1 = Math.max(pos.getY(), blockpos.getY()) + i + 1;
            if (i1 >= level.getMinBuildHeight() + 1 && j1 <= level.getMaxBuildHeight()) {
                OptionalInt optionalint = config.minimumSize.minClippedHeight();
                int k1 = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, i, blockpos, config);
                if (k1 >= i || optionalint.isPresent() && k1 >= optionalint.getAsInt()) {
                    if (config.rootPlacer.isPresent() && !config.rootPlacer.get().placeRoots((LevelSimulatedReader)level, root, random, pos, blockpos, (TreeConfiguration)config)) {
                        return false;
                    }
                    List list = config.trunkPlacer.placeTrunk((LevelSimulatedReader)level, trunk, random, k1, blockpos, (TreeConfiguration)config);
                    list.forEach(p_225279_ -> config.foliagePlacer.createFoliage((LevelSimulatedReader)level, foiliage, random, (TreeConfiguration)config, k1, p_225279_, j, l));
                    return true;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader p_67216_, int p_67217_, BlockPos p_67218_, TreeConfiguration p_67219_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= p_67217_ + 1; ++i) {
            int j = p_67219_.minimumSize.getSizeAtHeight(p_67217_, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    blockpos$mutableblockpos.setWithOffset((Vec3i)p_67218_, k, i, l);
                    if (p_67219_.trunkPlacer.isFree(p_67216_, (BlockPos)blockpos$mutableblockpos) && (p_67219_.ignoreVines || !JourneyTree.isVine(p_67216_, (BlockPos)blockpos$mutableblockpos))) continue;
                    return i - 2;
                }
            }
        }
        return p_67217_;
    }

    protected void setBlock(@NotNull LevelWriter l, @NotNull BlockPos p, @NotNull BlockState s) {
        JourneyTree.setBlockKnownShape(l, p, s);
    }

    public final boolean place(FeaturePlaceContext<TreeConfig> config) {
        final WorldGenLevel worldgenlevel = config.level();
        RandomSource randomsource = config.random();
        BlockPos blockpos = config.origin();
        TreeConfig treeconfiguration = (TreeConfig)config.config();
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        final HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> biconsumer = (p, s) -> {
            set.add(p.immutable());
            worldgenlevel.setBlock(p, s, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer1 = (p, s) -> {
            set1.add(p.immutable());
            worldgenlevel.setBlock(p, s, 19);
        };
        FoliagePlacer.FoliageSetter biconsumer2 = new FoliagePlacer.FoliageSetter(){

            public void set(BlockPos p_272825_, @NotNull BlockState s) {
                set2.add(p_272825_.immutable());
                worldgenlevel.setBlock(p_272825_, s, 19);
            }

            public boolean isSet(BlockPos p) {
                return set2.contains(p);
            }
        };
        BiConsumer<BlockPos, BlockState> biconsumer3 = (p, s) -> {
            set3.add(p.immutable());
            worldgenlevel.setBlock(p, s, 19);
        };
        boolean flag = this.doPlace(worldgenlevel, randomsource, blockpos, biconsumer, biconsumer1, biconsumer2, treeconfiguration);
        if (!(!flag || set1.isEmpty() && set2.isEmpty())) {
            if (!treeconfiguration.decorators.isEmpty()) {
                TreeDecorator.Context treedecorator$context = new TreeDecorator.Context((LevelSimulatedReader)worldgenlevel, biconsumer3, randomsource, (Set)set1, (Set)set2, (Set)set);
                treeconfiguration.decorators.forEach(l -> l.place(treedecorator$context));
            }
            return BoundingBox.encapsulatingPositions((Iterable)Iterables.concat((Iterable)set, (Iterable)set1, (Iterable)set2, (Iterable)set3)).map(s -> {
                DiscreteVoxelShape discretevoxelshape = JourneyTree.updateLeaves((LevelAccessor)worldgenlevel, s, set1, set3, set);
                StructureTemplate.updateShapeAtEdge((LevelAccessor)worldgenlevel, (int)3, (DiscreteVoxelShape)discretevoxelshape, (int)s.minX(), (int)s.minY(), (int)s.minZ());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static DiscreteVoxelShape updateLeaves(LevelAccessor level, BoundingBox bb, Set<BlockPos> s1, Set<BlockPos> s2, Set<BlockPos> s3) {
        ArrayList list = Lists.newArrayList();
        BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(bb.getXSpan(), bb.getYSpan(), bb.getZSpan());
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : Lists.newArrayList((Iterable)Sets.union(s2, s3))) {
            if (!bb.isInside((Vec3i)blockpos)) continue;
            discretevoxelshape.fill(blockpos.getX() - bb.minX(), blockpos.getY() - bb.minY(), blockpos.getZ() - bb.minZ());
        }
        for (BlockPos blockpos1 : Lists.newArrayList(s1)) {
            if (bb.isInside((Vec3i)blockpos1)) {
                discretevoxelshape.fill(blockpos1.getX() - bb.minX(), blockpos1.getY() - bb.minY(), blockpos1.getZ() - bb.minZ());
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos1, direction);
                if (s1.contains(blockpos$mutableblockpos) || !(blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos)).hasProperty((Property)BlockStateProperties.DISTANCE)) continue;
                ((Set)list.get(0)).add(blockpos$mutableblockpos.immutable());
                JourneyTree.setBlockKnownShape((LevelWriter)level, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate.setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1)));
                if (!bb.isInside((Vec3i)blockpos$mutableblockpos)) continue;
                discretevoxelshape.fill(blockpos$mutableblockpos.getX() - bb.minX(), blockpos$mutableblockpos.getY() - bb.minY(), blockpos$mutableblockpos.getZ() - bb.minZ());
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (bb.isInside((Vec3i)blockpos2)) {
                    discretevoxelshape.fill(blockpos2.getX() - bb.minX(), blockpos2.getY() - bb.minY(), blockpos2.getZ() - bb.minZ());
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutableblockpos) || set1.contains(blockpos$mutableblockpos) || !(blockstate1 = level.getBlockState((BlockPos)blockpos$mutableblockpos)).hasProperty((Property)BlockStateProperties.DISTANCE) || (k = ((Integer)blockstate1.getValue((Property)BlockStateProperties.DISTANCE)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(l + 1));
                    JourneyTree.setBlockKnownShape((LevelWriter)level, (BlockPos)blockpos$mutableblockpos, blockstate2);
                    if (bb.isInside((Vec3i)blockpos$mutableblockpos)) {
                        discretevoxelshape.fill(blockpos$mutableblockpos.getX() - bb.minX(), blockpos$mutableblockpos.getY() - bb.minY(), blockpos$mutableblockpos.getZ() - bb.minZ());
                    }
                    set1.add(blockpos$mutableblockpos.immutable());
                }
            }
        }
        return discretevoxelshape;
    }
}

