/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.tree_grower.decorators;

import com.mojang.serialization.MapCodec;
import net.jitl.common.world.gen.JTreeDecorators;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class IcyBrushTreeDecorator
extends TreeDecorator {
    public static final MapCodec<IcyBrushTreeDecorator> CODEC;
    public static final IcyBrushTreeDecorator INSTANCE;
    private final float probability;

    public IcyBrushTreeDecorator(float p) {
        this.probability = p;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)JTreeDecorators.ICY_BRUSH_TREE.get();
    }

    public void place(TreeDecorator.Context pContext) {
        RandomSource randomsource = pContext.random();
        pContext.leaves().forEach(d -> {
            BlockPos blockpos3;
            BlockPos blockpos2;
            BlockPos blockpos1;
            BlockPos blockpos;
            if (randomsource.nextFloat() < this.probability && pContext.isAir(blockpos = d.west())) {
                this.addHangingVine(blockpos, VineBlock.EAST, pContext);
            }
            if (randomsource.nextFloat() < this.probability && pContext.isAir(blockpos1 = d.east())) {
                this.addHangingVine(blockpos1, VineBlock.WEST, pContext);
            }
            if (randomsource.nextFloat() < this.probability && pContext.isAir(blockpos2 = d.north())) {
                this.addHangingVine(blockpos2, VineBlock.SOUTH, pContext);
            }
            if (randomsource.nextFloat() < this.probability && pContext.isAir(blockpos3 = d.south())) {
                this.addHangingVine(blockpos3, VineBlock.NORTH, pContext);
            }
        });
    }

    private void addHangingVine(BlockPos pPos, BooleanProperty pSideProperty, TreeDecorator.Context pContext) {
        this.placeBrush(pContext, pPos, pSideProperty);
        BlockPos blockpos = pPos.below();
        for (int i = pContext.random().nextInt(4) + 3; pContext.isAir(blockpos) && i > 0; --i) {
            this.placeBrush(pContext, pPos, pSideProperty);
            blockpos = blockpos.below();
        }
    }

    private void placeBrush(TreeDecorator.Context context, BlockPos pos, BooleanProperty sideProperty) {
        context.setBlock(pos, (BlockState)((Block)JBlocks.ICY_BRUSH.get()).defaultBlockState().setValue((Property)sideProperty, (Comparable)Boolean.TRUE));
    }

    static {
        INSTANCE = new IcyBrushTreeDecorator(0.2f);
        CODEC = MapCodec.unit(() -> INSTANCE);
    }
}

