/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.world.gen.tree_grower.foliageplacers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.jitl.common.world.gen.JFoliagePlacers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import org.jetbrains.annotations.NotNull;

public class SwampFoliagePlacer
extends BlobFoliagePlacer {
    public static final MapCodec<SwampFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> SwampFoliagePlacer.blobParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, SwampFoliagePlacer::new));

    public SwampFoliagePlacer(IntProvider featureSpread, IntProvider featureSpread1, int i) {
        super(featureSpread, featureSpread1, i);
    }

    @NotNull
    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)JFoliagePlacers.SPHERICAL_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(@NotNull LevelSimulatedReader reader, @NotNull FoliagePlacer.FoliageSetter blockSetter, @NotNull RandomSource rand, @NotNull TreeConfiguration baseTreeFeatureConfig, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment foliage, int foliageHeight, int foliageRadius, int offset) {
        int size = foliageRadius + foliage.radiusOffset();
        BlockPos pos = foliage.pos().above(offset);
        pos = pos.offset(Direction.UP.getNormal());
        for (int x = 0; x <= size; x = (int)((byte)(x + 1))) {
            for (int y = 0; y <= size; y = (int)((byte)(y + 1))) {
                for (int z = 0; z <= size; z = (int)((byte)(z + 1))) {
                    int distance = x >= y & x >= z ? x + (Math.max(y, z) >> 1) + (Math.min(y, z) >> 1) : (y >= x & y >= z ? y + (Math.max(x, z) >> 1) + (Math.min(x, z) >> 1) : z + (Math.max(x, y) >> 1) + (Math.min(x, y) >> 1));
                    if (distance > size) continue;
                    this.placeLeavesRow(reader, blockSetter, rand, baseTreeFeatureConfig, pos.offset(-x, y, z), foliageHeight, offset, false);
                    this.placeLeavesRow(reader, blockSetter, rand, baseTreeFeatureConfig, pos.offset(-x, y, -z), foliageHeight, offset, false);
                    this.placeLeavesRow(reader, blockSetter, rand, baseTreeFeatureConfig, pos.offset(x, y, z), foliageHeight, offset, false);
                    this.placeLeavesRow(reader, blockSetter, rand, baseTreeFeatureConfig, pos.offset(x, y, -z), foliageHeight, offset, false);
                }
            }
        }
    }

    public int foliageHeight(@NotNull RandomSource random, int height, @NotNull TreeConfiguration baseTreeFeatureConfig) {
        return 0;
    }

    protected boolean shouldSkipLocation(@NotNull RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        if (localY == 0) {
            return (localX > 1 || localZ > 1) && localX != 0 && localZ != 0;
        }
        return localX == range && localZ == range && range > 0;
    }
}

