/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public class JRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public JRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(RecipeOutput pRecipeOutput) {
    }

    protected void addSmithingRecipe(RecipeOutput recipeConsumer, ItemLike input, ItemLike modifier, Item result) {
    }

    protected void add3x3Recipe(RecipeOutput recipeConsumer, ItemLike input, ItemLike output) {
        this.add3x3Recipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, input, output);
    }

    protected void add3x3Recipe(RecipeOutput recipeConsumer, ItemLike input, ItemLike output, int count) {
        this.add3x3Recipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, input, output, count);
    }

    protected void add3x3Recipe(RecipeOutput recipeConsumer, RecipeCategory cat, ItemLike input, ItemLike output) {
        this.add3x3Recipe(recipeConsumer, cat, input, output, 1);
    }

    protected void add3x3Recipe(RecipeOutput recipeConsumer, RecipeCategory cat, ItemLike input, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped((RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf('#'), input).pattern("###").pattern("###").pattern("###").unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String t, String m, String b, char s, ItemLike input, ItemLike output, int count, String name) {
        ShapedRecipeBuilder.shaped((RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).pattern(t).pattern(m).pattern(b).unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).save(recipeConsumer, String.valueOf(this.getItemFromRegistryName(input.toString())) + name);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String m, String b, char s, ItemLike input, char s2, ItemLike input2, char s3, ItemLike input3, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped((RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).define(Character.valueOf(s2), input2).define(Character.valueOf(s3), input3).pattern(m).pattern(b).unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String m, String b, char s, ItemLike input, char s2, ItemLike input2, char s3, TagKey<Item> input3, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped((RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).define(Character.valueOf(s2), input2).define(Character.valueOf(s3), input3).pattern(m).pattern(b).unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String t, String m, String b, char s, ItemLike input, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped((RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).pattern(t).pattern(m).pattern(b).unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String t, char s, ItemLike input, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped((RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).pattern(t).unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String t, String m, char s, ItemLike input, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped((RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).pattern(t).pattern(m).unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, String t, String m, String b, char s, ItemLike input, ItemLike output, int count) {
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, t, m, b, s, input, output, count);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String t, String m, String b, char s, ItemLike input, char s2, ItemLike input2, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped((RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).define(Character.valueOf(s2), input2).pattern(t).pattern(m).pattern(b).unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String t, String m, String b, char s, ItemLike input, char s2, ItemLike input2, char s3, ItemLike input3, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped((RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).define(Character.valueOf(s2), input2).define(Character.valueOf(s3), input3).pattern(t).pattern(m).pattern(b).unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String t, String m, String b, char s, ItemLike input, char s2, ItemLike input2, char s3, TagKey<Item> input3, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped((RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).define(Character.valueOf(s2), input2).define(Character.valueOf(s3), input3).pattern(t).pattern(m).pattern(b).unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, String t, String m, char s, ItemLike input, char s2, ItemLike input2, ItemLike output, int count) {
        ShapedRecipeBuilder.shaped((RecipeCategory)cat, (ItemLike)output, (int)count).define(Character.valueOf(s), input).define(Character.valueOf(s2), input2).pattern(t).pattern(m).unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).save(recipeConsumer);
    }

    protected void addShapedRecipe(RecipeOutput recipeConsumer, String t, String m, String b, char s, ItemLike input, char s2, ItemLike input2, ItemLike output, int count) {
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, t, m, b, s, input, s2, input2, output, count);
    }

    protected void addShapelessRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, ItemLike input, ItemLike output, int count) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)cat, (ItemLike)output, (int)count).requires(input).unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).save(recipeConsumer);
    }

    protected void addShapelessRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, ItemLike input, ItemLike input2, ItemLike output, int count, String name) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)cat, (ItemLike)output, (int)count).requires(input).requires(input2).unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).unlockedBy(this.inputToKey(input2), JRecipeProvider.has((ItemLike)input2)).save(recipeConsumer, this.getItemFromRegistryName(output.toString()).toString() + name);
    }

    protected void addShapelessRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, ItemLike input, ItemLike input2, ItemLike output, int count) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)cat, (ItemLike)output, (int)count).requires(input).requires(input2).unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).unlockedBy(this.inputToKey(input2), JRecipeProvider.has((ItemLike)input2)).save(recipeConsumer);
    }

    protected void addShapelessRecipe(RecipeOutput recipeConsumer, RecipeCategory cat, ItemLike input, ItemLike input2, ItemLike input3, ItemLike output, int count) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)cat, (ItemLike)output, (int)count).requires(input).requires(input2).requires(input3).unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).unlockedBy(this.inputToKey(input2), JRecipeProvider.has((ItemLike)input2)).save(recipeConsumer);
    }

    protected void addOreBlockRecipe(RecipeOutput recipeConsumer, ItemLike input, ItemLike output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)1).define(Character.valueOf('#'), input).pattern("###").pattern("###").pattern("###").unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).save(recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)input, (int)9).requires(output).unlockedBy(this.inputToKey(output), JRecipeProvider.has((ItemLike)output)).group(input.asItem().toString()).save(recipeConsumer, String.valueOf(this.getItemFromRegistryName(input.toString())) + "_from_block");
    }

    protected void add2x2Recipe(RecipeOutput recipeConsumer, ItemLike input, ItemLike output, int count, boolean addReverse) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)count).define(Character.valueOf('#'), input).pattern("##").pattern("##").unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).save(recipeConsumer);
        if (addReverse) {
            this.addShapelessRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, output, input, 4);
        }
    }

    protected void add2x2Recipe(RecipeOutput recipeConsumer, ItemLike input, ItemLike output, boolean addReverse) {
        this.add2x2Recipe(recipeConsumer, input, output, 1, addReverse);
    }

    public void addOreDefaultItems(RecipeOutput recipeConsumer, RecipePrefix name, ItemLike block, ItemLike oreBlock, ItemLike deepslateOre, ItemLike raw, ItemLike ingot, ItemLike stickItem) {
        this.addToolsetAndArmorRecipes(recipeConsumer, stickItem, ingot, name);
        this.addShieldRecipe(recipeConsumer, ingot, this.getItemFromRegistryName("jitl:" + name.getString() + "shield"));
        this.addOreBlockRecipe(recipeConsumer, ingot, block);
        this.addBlastingRecipe(recipeConsumer, oreBlock, ingot, 1.0f, 100, "_ore_blasting");
        this.addSmeltingRecipe(recipeConsumer, oreBlock, ingot, 1.0f, 200, "_ore_smelting");
        if (deepslateOre != null) {
            this.addBlastingRecipe(recipeConsumer, deepslateOre, ingot, 1.0f, 100, "_deep_blasting");
            this.addSmeltingRecipe(recipeConsumer, deepslateOre, ingot, 1.0f, 200, "_deep_smelting");
        }
        if (raw != null) {
            this.addBlastingRecipe(recipeConsumer, raw, ingot, 1.0f, 100, "_raw_blasting");
            this.addSmeltingRecipe(recipeConsumer, raw, ingot, 1.0f, 200, "_raw_smelting");
        }
    }

    public void addOreNoArmorItems(RecipeOutput recipeConsumer, RecipePrefix name, ItemLike block, ItemLike oreBlock, ItemLike deepslateOre, ItemLike raw, ItemLike ingot, ItemLike stickItem) {
        this.addToolsetRecipes(recipeConsumer, stickItem, ingot, name);
        this.addShieldRecipe(recipeConsumer, ingot, this.getItemFromRegistryName("jitl:" + name.getString() + "shield"));
        this.addOreBlockRecipe(recipeConsumer, ingot, block);
        if (oreBlock != null) {
            this.addBlastingRecipe(recipeConsumer, oreBlock, ingot, 1.0f, 100, "_ore_blasting");
            this.addSmeltingRecipe(recipeConsumer, oreBlock, ingot, 1.0f, 200, "_ore_smelting");
        }
        if (deepslateOre != null) {
            this.addBlastingRecipe(recipeConsumer, deepslateOre, ingot, 1.0f, 100, "_deep_blasting");
            this.addSmeltingRecipe(recipeConsumer, deepslateOre, ingot, 1.0f, 200, "_deep_smelting");
        }
        if (raw != null) {
            this.addBlastingRecipe(recipeConsumer, raw, ingot, 1.0f, 100, "_raw_blasting");
            this.addSmeltingRecipe(recipeConsumer, raw, ingot, 1.0f, 200, "_raw_smelting");
        }
    }

    protected void addToolsetAndArmorRecipes(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, RecipePrefix recipePrefix) {
        this.addToolsetRecipes(recipeConsumer, stickItem, materialItem, recipePrefix);
        this.addArmorRecipes(recipeConsumer, materialItem, recipePrefix);
    }

    protected void addToolsetRecipes(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, RecipePrefix recipePrefix) {
        this.addAxeRecipe(recipeConsumer, stickItem, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "axe"));
        this.addPickaxeRecipe(recipeConsumer, stickItem, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "pickaxe"));
        this.addShovelRecipe(recipeConsumer, stickItem, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "shovel"));
        this.addSwordRecipe(recipeConsumer, stickItem, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "sword"));
        this.addHoeRecipe(recipeConsumer, stickItem, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "hoe"));
        this.addMultitoolRecipe(recipeConsumer, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "axe"), this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "pickaxe"), this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "shovel"), this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "hoe"), this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "multitool"));
    }

    public void addArmorRecipes(RecipeOutput recipeConsumer, ItemLike materialItem, RecipePrefix recipePrefix) {
        this.addHelmetRecipe(recipeConsumer, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "helmet"));
        this.addChestplateRecipe(recipeConsumer, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "chestplate"));
        this.addLeggingsRecipe(recipeConsumer, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "leggings"));
        this.addBootsRecipe(recipeConsumer, materialItem, this.getItemFromRegistryName("jitl:" + recipePrefix.getString() + "boots"));
    }

    public void addWoodType(RecipeOutput recipeConsumer, DeferredBlock<? extends Block> log, DeferredBlock<? extends Block> plank, DeferredBlock<? extends Block> stairs, DeferredBlock<? extends Block> slab, DeferredBlock<? extends Block> fence, DeferredBlock<? extends Block> gate, DeferredBlock<? extends Block> trapdoor, DeferredBlock<? extends Block> pressureplate, DeferredBlock<? extends Block> door, DeferredBlock<? extends Block> button, DeferredItem<Item> boat) {
        this.addAxeRecipe(recipeConsumer, (ItemLike)Items.STICK, (ItemLike)plank.get(), (ItemLike)Items.WOODEN_AXE, ((Block)plank.get()).getDescriptionId());
        this.addPickaxeRecipe(recipeConsumer, (ItemLike)Items.STICK, (ItemLike)plank.get(), (ItemLike)Items.WOODEN_PICKAXE, ((Block)plank.get()).getDescriptionId());
        this.addShovelRecipe(recipeConsumer, (ItemLike)Items.STICK, (ItemLike)plank.get(), (ItemLike)Items.WOODEN_SHOVEL, ((Block)plank.get()).getDescriptionId());
        this.addSwordRecipe(recipeConsumer, (ItemLike)Items.STICK, (ItemLike)plank.get(), (ItemLike)Items.WOODEN_SWORD, ((Block)plank.get()).getDescriptionId());
        this.addHoeRecipe(recipeConsumer, (ItemLike)Items.STICK, (ItemLike)plank.get(), (ItemLike)Items.WOODEN_HOE, ((Block)plank.get()).getDescriptionId());
        this.addBoatRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)boat.get());
        this.addStairRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)stairs.get());
        this.addSlabRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)slab.get());
        this.addFenceRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)Items.STICK, (ItemLike)fence.get());
        this.addFenceGateRecipe(recipeConsumer, (ItemLike)Items.STICK, (ItemLike)plank.get(), (ItemLike)gate.get());
        this.addTrapdoorRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)trapdoor.get());
        this.addPressureplateRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)pressureplate.get());
        this.addDoorRecipe(recipeConsumer, (ItemLike)plank.get(), (ItemLike)door.get());
        this.addStick(recipeConsumer, (ItemLike)plank.get());
        this.planksFromLogs(recipeConsumer, (ItemLike)plank.get(), (ItemLike)log.get());
        this.buttonBuilder(recipeConsumer, (ItemLike)button.get(), (ItemLike)plank.get());
    }

    public void addQuartzType(RecipeOutput recipeConsumer, DeferredItem<? extends Item> quartz, DeferredBlock<? extends Block> quartzOre, DeferredBlock<? extends Block> quartzBlock, DeferredBlock<? extends Block> smoothQuartzBlock, DeferredBlock<? extends Block> quartzStairs, DeferredBlock<? extends Block> smoothQuartzStairs, DeferredBlock<? extends Block> quartzSlab, DeferredBlock<? extends Block> smoothQuartzSlab, DeferredBlock<? extends Block> quartzBricks, DeferredBlock<? extends Block> chiseledQuartzBlock, DeferredBlock<? extends Block> quartzPillar) {
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)quartzBlock.get(), (ItemLike)smoothQuartzBlock.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)quartzOre.get(), (ItemLike)quartz.get());
        this.add2x2Recipe(recipeConsumer, (ItemLike)quartz.get(), (ItemLike)quartzBlock.get(), false);
        this.addStairRecipe(recipeConsumer, (ItemLike)quartzBlock.get(), (ItemLike)quartzStairs.get());
        this.addSlabRecipe(recipeConsumer, (ItemLike)quartzBlock.get(), (ItemLike)quartzSlab.get());
        this.addStairRecipe(recipeConsumer, (ItemLike)smoothQuartzBlock.get(), (ItemLike)smoothQuartzStairs.get());
        this.addSlabRecipe(recipeConsumer, (ItemLike)smoothQuartzBlock.get(), (ItemLike)smoothQuartzSlab.get());
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "s", "s", 's', (ItemLike)quartzSlab.get(), (ItemLike)chiseledQuartzBlock.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "s", "s", 's', (ItemLike)quartzBlock.get(), (ItemLike)quartzPillar.get(), 2);
        this.add2x2Recipe(recipeConsumer, (ItemLike)quartzBlock.get(), (ItemLike)quartzBricks.get(), 4, false);
    }

    protected void buttonBuilder(RecipeOutput recipeConsumer, ItemLike button, ItemLike material) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)button).requires(material).unlockedBy(this.inputToKey(material), JRecipeProvider.has((ItemLike)material)).save(recipeConsumer);
    }

    protected void planksFromLogs(RecipeOutput finishedRecipeConsumer, ItemLike planks, ItemLike logs) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, (int)4).requires(logs).unlockedBy(this.inputToKey(logs), JRecipeProvider.has((ItemLike)logs)).save(finishedRecipeConsumer);
    }

    protected void addStick(RecipeOutput recipeConsumer, ItemLike materialItem) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK, (int)4).define(Character.valueOf('#'), materialItem).pattern("#").pattern("#").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer, materialItem.asItem().getDescriptionId() + "_to_stick");
    }

    protected void addDoorRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("##").pattern("##").pattern("##").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
    }

    protected void addPressureplateRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("##").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
    }

    protected void addTrapdoorRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("###").pattern("###").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
    }

    protected void addFenceGateRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("#I#").pattern("#I#").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
    }

    protected void addFenceRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("#I#").pattern("#I#").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
    }

    protected void addSlabRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)6).define(Character.valueOf('#'), materialItem).pattern("###").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
    }

    protected void addStairRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("#  ").pattern("## ").pattern("###").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
    }

    protected void addBoatRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("# #").pattern("###").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
    }

    protected void addPickaxeRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output, String name) {
        if (!Objects.equals(name, "")) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("###").pattern(" I ").pattern(" I ").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer, materialItem.asItem().getDescriptionId() + "_to_pickaxe");
        } else {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("###").pattern(" I ").pattern(" I ").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
        }
    }

    protected void addShovelRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output, String name) {
        if (!Objects.equals(name, "")) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("#").pattern("I").pattern("I").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer, materialItem.asItem().getDescriptionId() + "_to_shovel");
        } else {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("#").pattern("I").pattern("I").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
        }
    }

    protected void addAxeRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output, String name) {
        if (!Objects.equals(name, "")) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("##").pattern("#I").pattern(" I").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer, materialItem.asItem().getDescriptionId() + "_to_axe");
        } else {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("##").pattern("#I").pattern(" I").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
        }
    }

    protected void addHoeRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output, String name) {
        if (!Objects.equals(name, "")) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("##").pattern(" I").pattern(" I").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer, materialItem.asItem().getDescriptionId() + "_to_hoe");
        } else {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("##").pattern(" I").pattern(" I").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
        }
    }

    protected void addMultitoolRecipe(RecipeOutput recipeConsumer, ItemLike axe, ItemLike pick, ItemLike shovel, ItemLike hoe, ItemLike output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output).requires(axe).requires(pick).requires(shovel).requires(hoe).unlockedBy(this.inputToKey(axe), JRecipeProvider.has((ItemLike)axe)).save(recipeConsumer);
    }

    protected void addSwordRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output, String name) {
        if (!Objects.equals(name, "")) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("#").pattern("#").pattern("I").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer, materialItem.asItem().getDescriptionId() + "_to_sword");
        } else {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).define(Character.valueOf('I'), stickItem).pattern("#").pattern("#").pattern("I").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
        }
    }

    protected void addPickaxeRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output) {
        this.addPickaxeRecipe(recipeConsumer, stickItem, materialItem, output, "");
    }

    protected void addShovelRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output) {
        this.addShovelRecipe(recipeConsumer, stickItem, materialItem, output, "");
    }

    protected void addAxeRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output) {
        this.addAxeRecipe(recipeConsumer, stickItem, materialItem, output, "");
    }

    protected void addHoeRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output) {
        this.addHoeRecipe(recipeConsumer, stickItem, materialItem, output, "");
    }

    protected void addSwordRecipe(RecipeOutput recipeConsumer, ItemLike stickItem, ItemLike materialItem, ItemLike output) {
        this.addSwordRecipe(recipeConsumer, stickItem, materialItem, output, "");
    }

    protected static void threeByThreePacker(@NotNull RecipeOutput pRecipeOutput, @NotNull RecipeCategory pCategory, ItemLike pPacked, @NotNull ItemLike pUnpacked, @NotNull String pCriterionName) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)pCategory, (ItemLike)pPacked).requires(pUnpacked, 9).unlockedBy(pCriterionName, JRecipeProvider.has((ItemLike)pUnpacked)).save(pRecipeOutput);
    }

    protected void addShieldRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output, (int)1).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('M'), materialItem).pattern("#M#").pattern("###").pattern(" # ").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
    }

    protected void addHelmetRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("###").pattern("# #").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
    }

    protected void addChestplateRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("# #").pattern("###").pattern("###").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
    }

    protected void addLeggingsRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("###").pattern("# #").pattern("# #").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
    }

    protected void addBootsRecipe(RecipeOutput recipeConsumer, ItemLike materialItem, ItemLike output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)output, (int)1).define(Character.valueOf('#'), materialItem).pattern("# #").pattern("# #").unlockedBy(this.inputToKey(materialItem), JRecipeProvider.has((ItemLike)materialItem)).save(recipeConsumer);
    }

    protected void addSmeltingRecipe(RecipeOutput consumer, ItemLike input, ItemLike output, float xpGiven, int time, String name) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)xpGiven, (int)time).unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).save(consumer, output.asItem().getDescriptionId() + name);
    }

    protected void addBlastingRecipe(RecipeOutput consumer, ItemLike input, ItemLike output, float xpGiven, int time, String name) {
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)xpGiven, (int)time).unlockedBy(this.inputToKey(input), JRecipeProvider.has((ItemLike)input)).save(consumer, output.asItem().getDescriptionId() + name);
    }

    protected void addSmeltingRecipe(RecipeOutput consumer, ItemLike input, ItemLike output, float xpGiven, int time) {
        this.addSmeltingRecipe(consumer, input, output, xpGiven, time, "");
    }

    protected void addBlastingRecipe(RecipeOutput consumer, ItemLike input, ItemLike output, float xpGiven, int time) {
        this.addBlastingRecipe(consumer, input, output, xpGiven, time, "");
    }

    protected void addSmeltingAndBlastingRecipe(RecipeOutput consumer, ItemLike input, ItemLike output) {
        this.addSmeltingRecipe(consumer, input, output, 1.0f, 200, "_smelting");
        this.addBlastingRecipe(consumer, input, output, 1.0f, 100, "_blasting");
    }

    protected void addCookingRecipe(ItemLike input, ItemLike output, float xpGiven) {
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)xpGiven, (int)100);
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)xpGiven, (int)600);
    }

    protected String inputToKey(ItemLike input) {
        return "has_item";
    }

    public ItemLike getItemFromRegistryName(String registryName) {
        return (ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)registryName));
    }

    public static enum RecipePrefix {
        SAPPHIRE("sapphire_"),
        LUNIUM("lunium_"),
        SHADIUM("shadium_"),
        BLOODCRUST("bloodcrust_"),
        CELESTIUM("celestium_"),
        STORON("storon_"),
        KORITE("korite_"),
        MEKYUM("mekyum_"),
        FLAIRIUM("flairium_"),
        DES("des_"),
        ORBADITE("orbadite_"),
        GORBITE("gorbite_"),
        SOULSTONE("soulstone_"),
        WOODEN("wooden_");

        String prefix;

        private RecipePrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getString() {
            return this.prefix;
        }
    }
}

