/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.init.internal.JItems;

public class JShieldItemGenerator {
    protected BufferedWriter itemModelWriter;
    protected BufferedWriter blockingWriter;

    public void generate() {
        for (String name : JItems.shieldName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String itemModelBlockingDir = "../src/main/resources/assets/jitl/models/item/" + name + "_blocking.json";
            File itemModel = new File(itemModelDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            File itemModelBlocking = new File(itemModelBlockingDir);
            try {
                if (itemModelBlocking.exists()) {
                    itemModelBlocking.delete();
                }
                itemModelBlocking.createNewFile();
                this.blockingWriter = new BufferedWriter(new FileWriter(itemModelBlocking));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getItem("jitl", name);
            this.itemModelInit();
        }
    }

    public void getItem(String modID, String name) {
        this.writeToItemModelFile(this.itemModelWriter, "{");
        this.writeToItemModelFile(this.itemModelWriter, "  \"parent\": \"item/shield\",");
        this.writeToItemModelFile(this.itemModelWriter, "  \"textures\": {");
        this.writeToItemModelFile(this.itemModelWriter, "    \"particle\": \"" + modID + ":shield/" + name + "\"");
        this.writeToItemModelFile(this.itemModelWriter, "  },");
        this.writeToItemModelFile(this.itemModelWriter, "  \"overrides\": [");
        this.writeToItemModelFile(this.itemModelWriter, "    {");
        this.writeToItemModelFile(this.itemModelWriter, "      \"predicate\": {");
        this.writeToItemModelFile(this.itemModelWriter, "        \"" + modID + ":blocking\": 1");
        this.writeToItemModelFile(this.itemModelWriter, "      },");
        this.writeToItemModelFile(this.itemModelWriter, "      \"model\": \"" + modID + ":item/" + name + "_blocking\"");
        this.writeToItemModelFile(this.itemModelWriter, "    }");
        this.writeToItemModelFile(this.itemModelWriter, "  ]");
        this.writeToItemModelFile(this.itemModelWriter, "}");
        this.writeToItemModelFile(this.blockingWriter, "{");
        this.writeToItemModelFile(this.blockingWriter, "  \"parent\": \"item/shield_blocking\",");
        this.writeToItemModelFile(this.blockingWriter, "  \"textures\": {");
        this.writeToItemModelFile(this.blockingWriter, "    \"particle\": \"" + modID + ":shield/" + name + "\"");
        this.writeToItemModelFile(this.blockingWriter, "  }");
        this.writeToItemModelFile(this.blockingWriter, "}");
    }

    public void itemModelInit() {
        try {
            this.itemModelWriter.close();
            this.blockingWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(BufferedWriter writer, String text) {
        try {
            writer.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

