/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.init.internal.JBlocks;

public class BlockTotemGenerator {
    protected BufferedWriter blockModelWriter;
    protected BufferedWriter blockAwakeModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.totemBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir = "../src/main/resources/assets/jitl/models/block/" + name + ".json";
            String blockAwakeModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_awake.json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockModel = new File(blockModelDir);
            File blockAwakeModel = new File(blockAwakeModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockModel.exists()) {
                    blockModel.delete();
                }
                blockModel.createNewFile();
                this.blockModelWriter = new BufferedWriter(new FileWriter(blockModel));
                if (blockAwakeModel.exists()) {
                    blockAwakeModel.delete();
                }
                blockAwakeModel.createNewFile();
                this.blockAwakeModelWriter = new BufferedWriter(new FileWriter(blockAwakeModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockAwakeModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"" + modID + ":block/" + name + "\"");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile("{");
        this.writeToBlockModelFile("  \"parent\": \"minecraft:block/cube_column\",");
        this.writeToBlockModelFile("  \"textures\": {");
        this.writeToBlockModelFile("    \"end\": \"" + modID + ":block/totem_base_top\",");
        this.writeToBlockModelFile("    \"side\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockModelFile("  }");
        this.writeToBlockModelFile("}");
    }

    public void getBlockAwakeModel(String modID, String name) {
        this.writeToBlockAwakeModelFile("{");
        this.writeToBlockAwakeModelFile("  \"parent\": \"minecraft:block/cube_column\",");
        this.writeToBlockAwakeModelFile("  \"textures\": {");
        this.writeToBlockAwakeModelFile("    \"end\": \"" + modID + ":block/totem_base_top\",");
        this.writeToBlockAwakeModelFile("    \"side\": \"" + modID + ":block/" + name + "_awake\"");
        this.writeToBlockAwakeModelFile("  }");
        this.writeToBlockAwakeModelFile("}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        this.writeToBlockstateFile("    \"awake=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_awake\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"awake=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockModelWriter.close();
            this.blockAwakeModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockAwakeModelFile(String text) {
        try {
            this.blockAwakeModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(String text) {
        try {
            this.blockModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

