/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.init.internal.JBlocks;

public class JBlockEndFrameGenerator {
    protected BufferedWriter blockModelWriter;
    protected BufferedWriter blockFilledModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.basePortalFrameBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir = "../src/main/resources/assets/jitl/models/block/" + name + ".json";
            String blockFilledModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_filled.json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockModel = new File(blockModelDir);
            File blockFilledModel = new File(blockFilledModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockModel.exists()) {
                    blockModel.delete();
                }
                blockModel.createNewFile();
                this.blockModelWriter = new BufferedWriter(new FileWriter(blockModel));
                if (blockFilledModel.exists()) {
                    blockFilledModel.delete();
                }
                blockFilledModel.createNewFile();
                this.blockFilledModelWriter = new BufferedWriter(new FileWriter(blockFilledModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"" + modID + ":block/" + name + "\"");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile(this.blockModelWriter, "{");
        this.writeToBlockModelFile(this.blockModelWriter, "  \"parent\": \"minecraft:block/end_portal_frame\",");
        this.writeToBlockModelFile(this.blockModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"particle\": \"" + modID + ":block/" + name + "_side\",");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"bottom\": \"" + modID + ":block/" + name + "_bottom\",");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"top\": \"" + modID + ":block/" + name + "_top\",");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"side\": \"" + modID + ":block/" + name + "_side\"");
        this.writeToBlockModelFile(this.blockModelWriter, "  }");
        this.writeToBlockModelFile(this.blockModelWriter, "}");
        this.writeToBlockModelFile(this.blockFilledModelWriter, "{");
        this.writeToBlockModelFile(this.blockFilledModelWriter, "  \"parent\": \"minecraft:block/end_portal_frame_filled\",");
        this.writeToBlockModelFile(this.blockFilledModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockFilledModelWriter, "    \"particle\": \"" + modID + ":block/" + name + "_side\",");
        this.writeToBlockModelFile(this.blockFilledModelWriter, "    \"bottom\": \"" + modID + ":block/" + name + "_bottom\",");
        this.writeToBlockModelFile(this.blockFilledModelWriter, "    \"top\": \"" + modID + ":block/" + name + "_top\",");
        this.writeToBlockModelFile(this.blockFilledModelWriter, "    \"side\": \"" + modID + ":block/" + name + "_side\",");
        this.writeToBlockModelFile(this.blockFilledModelWriter, "    \"eye\": \"" + modID + ":block/" + name + "_eye\"");
        this.writeToBlockModelFile(this.blockFilledModelWriter, "  }");
        this.writeToBlockModelFile(this.blockFilledModelWriter, "}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        this.writeToBlockstateFile("    \"eye=false,facing=east\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("      \"y\": 270");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"eye=false,facing=north\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("      \"y\": 180");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"eye=false,facing=south\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"eye=false,facing=west\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("      \"y\": 90");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"eye=true,facing=east\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "_filled\",");
        this.writeToBlockstateFile("      \"y\": 270");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"eye=true,facing=north\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "_filled\",");
        this.writeToBlockstateFile("      \"y\": 180");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"eye=true,facing=south\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "_filled\"");
        this.writeToBlockstateFile("    },");
        this.writeToBlockstateFile("    \"eye=true,facing=west\": {");
        this.writeToBlockstateFile("      \"model\": \"" + modID + ":block/" + name + "_filled\",");
        this.writeToBlockstateFile("      \"y\": 90");
        this.writeToBlockstateFile("    }");
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockModelWriter.close();
            this.blockFilledModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(BufferedWriter writer, String text) {
        try {
            writer.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

