/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.init.internal.JBlockProperties;
import net.jitl.core.init.internal.JBlocks;

public class JBlockGateGenerator {
    protected BufferedWriter blockModelWriter;
    protected BufferedWriter blockGateOpenModelWriter;
    protected BufferedWriter blockGateWallModelWriter;
    protected BufferedWriter blockGateWallOpenModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.gateBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir = "../src/main/resources/assets/jitl/models/block/" + name + ".json";
            String blockOpenModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_open.json";
            String blockWallModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_wall.json";
            String blockWallOpenModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_wall_open.json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockModel = new File(blockModelDir);
            File blockOpenModel = new File(blockOpenModelDir);
            File blockWallModel = new File(blockWallModelDir);
            File blockWallOpenModel = new File(blockWallOpenModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockModel.exists()) {
                    blockModel.delete();
                }
                blockModel.createNewFile();
                this.blockModelWriter = new BufferedWriter(new FileWriter(blockModel));
                if (blockOpenModel.exists()) {
                    blockOpenModel.delete();
                }
                blockOpenModel.createNewFile();
                this.blockGateOpenModelWriter = new BufferedWriter(new FileWriter(blockOpenModel));
                if (blockWallModel.exists()) {
                    blockWallModel.delete();
                }
                blockWallModel.createNewFile();
                this.blockGateWallModelWriter = new BufferedWriter(new FileWriter(blockWallModel));
                if (blockWallOpenModel.exists()) {
                    blockWallOpenModel.delete();
                }
                blockWallOpenModel.createNewFile();
                this.blockGateWallOpenModelWriter = new BufferedWriter(new FileWriter(blockWallOpenModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"" + modID + ":block/" + name + "\"");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile(this.blockModelWriter, "{");
        this.writeToBlockModelFile(this.blockModelWriter, "  \"parent\": \"minecraft:block/template_fence_gate\",");
        this.writeToBlockModelFile(this.blockModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"texture\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockModelWriter, "  }");
        this.writeToBlockModelFile(this.blockModelWriter, "}");
        this.writeToBlockModelFile(this.blockGateOpenModelWriter, "{");
        this.writeToBlockModelFile(this.blockGateOpenModelWriter, "  \"parent\": \"minecraft:block/template_fence_gate_open\",");
        this.writeToBlockModelFile(this.blockGateOpenModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockGateOpenModelWriter, "    \"texture\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockGateOpenModelWriter, "  }");
        this.writeToBlockModelFile(this.blockGateOpenModelWriter, "}");
        this.writeToBlockModelFile(this.blockGateWallModelWriter, "{");
        this.writeToBlockModelFile(this.blockGateWallModelWriter, "  \"parent\": \"minecraft:block/template_fence_gate_wall\",");
        this.writeToBlockModelFile(this.blockGateWallModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockGateWallModelWriter, "    \"texture\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockGateWallModelWriter, "  }");
        this.writeToBlockModelFile(this.blockGateWallModelWriter, "}");
        this.writeToBlockModelFile(this.blockGateWallOpenModelWriter, "{");
        this.writeToBlockModelFile(this.blockGateWallOpenModelWriter, "  \"parent\": \"minecraft:block/template_fence_gate_wall_open\",");
        this.writeToBlockModelFile(this.blockGateWallOpenModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockGateWallOpenModelWriter, "    \"texture\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockGateWallOpenModelWriter, "  }");
        this.writeToBlockModelFile(this.blockGateWallOpenModelWriter, "}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        this.writeToBlockstateFile("    \"facing=east,in_wall=false,open=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=east,in_wall=false,open=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_open\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=east,in_wall=true,open=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_wall\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=east,in_wall=true,open=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_wall_open\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 270");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,in_wall=false,open=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,in_wall=false,open=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_open\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,in_wall=true,open=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_wall\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=north,in_wall=true,open=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_wall_open\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 180");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,in_wall=false,open=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"uvlock\": true");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,in_wall=false,open=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_open\",");
        this.writeToBlockstateFile("         \"uvlock\": true");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,in_wall=true,open=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_wall\",");
        this.writeToBlockstateFile("         \"uvlock\": true");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=south,in_wall=true,open=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_wall_open\",");
        this.writeToBlockstateFile("         \"uvlock\": true");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,in_wall=false,open=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,in_wall=false,open=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_open\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,in_wall=true,open=false\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_wall\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"facing=west,in_wall=true,open=true\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_wall_open\",");
        this.writeToBlockstateFile("         \"uvlock\": true,");
        this.writeToBlockstateFile("         \"y\": 90");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockModelWriter.close();
            this.blockGateOpenModelWriter.close();
            this.blockGateWallModelWriter.close();
            this.blockGateWallOpenModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(BufferedWriter writer, String text) {
        try {
            writer.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

