/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.block_generation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.jitl.core.init.internal.JBlockProperties;
import net.jitl.core.init.internal.JBlocks;

public class JBlockSlabGenerator {
    protected BufferedWriter blockModelWriter;
    protected BufferedWriter blockTopModelWriter;
    protected BufferedWriter blockstateWriter;
    protected BufferedWriter itemModelWriter;

    public void generate() {
        for (String name : JBlocks.slabBlockName) {
            String itemModelDir = "../src/main/resources/assets/jitl/models/item/" + name + ".json";
            String blockModelDir = "../src/main/resources/assets/jitl/models/block/" + name + ".json";
            String blockTopModelDir = "../src/main/resources/assets/jitl/models/block/" + name + "_top.json";
            String blockstateDir = "../src/main/resources/assets/jitl/blockstates/" + name + ".json";
            File itemModel = new File(itemModelDir);
            File blockModel = new File(blockModelDir);
            File blockTopModel = new File(blockTopModelDir);
            File blockstateModel = new File(blockstateDir);
            try {
                if (itemModel.exists()) {
                    itemModel.delete();
                }
                itemModel.createNewFile();
                this.itemModelWriter = new BufferedWriter(new FileWriter(itemModel));
                if (blockModel.exists()) {
                    blockModel.delete();
                }
                blockModel.createNewFile();
                this.blockModelWriter = new BufferedWriter(new FileWriter(blockModel));
                if (blockTopModel.exists()) {
                    blockTopModel.delete();
                }
                blockTopModel.createNewFile();
                this.blockTopModelWriter = new BufferedWriter(new FileWriter(blockTopModel));
                if (blockstateModel.exists()) {
                    blockstateModel.delete();
                }
                blockstateModel.createNewFile();
                this.blockstateWriter = new BufferedWriter(new FileWriter(blockstateModel));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getBlockItem("jitl", name);
            this.getBlockModel("jitl", name);
            this.getBlockstate("jitl", name);
            this.writerInit();
        }
    }

    public void getBlockItem(String modID, String name) {
        this.writeToItemModelFile("{");
        this.writeToItemModelFile("  \"parent\": \"" + modID + ":block/" + name + "\"");
        this.writeToItemModelFile("}");
    }

    public void getBlockModel(String modID, String name) {
        this.writeToBlockModelFile(this.blockModelWriter, "{");
        this.writeToBlockModelFile(this.blockModelWriter, "  \"parent\": \"minecraft:block/slab\",");
        this.writeToBlockModelFile(this.blockModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"bottom\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\",");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"side\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\",");
        this.writeToBlockModelFile(this.blockModelWriter, "    \"top\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockModelWriter, "  }");
        this.writeToBlockModelFile(this.blockModelWriter, "}");
        this.writeToBlockModelFile(this.blockTopModelWriter, "{");
        this.writeToBlockModelFile(this.blockTopModelWriter, "  \"parent\": \"minecraft:block/slab_top\",");
        this.writeToBlockModelFile(this.blockTopModelWriter, "  \"textures\": {");
        this.writeToBlockModelFile(this.blockTopModelWriter, "    \"bottom\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\",");
        this.writeToBlockModelFile(this.blockTopModelWriter, "    \"side\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\",");
        this.writeToBlockModelFile(this.blockTopModelWriter, "    \"top\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockModelFile(this.blockTopModelWriter, "  }");
        this.writeToBlockModelFile(this.blockTopModelWriter, "}");
    }

    public void getBlockstate(String modID, String name) {
        this.writeToBlockstateFile("{");
        this.writeToBlockstateFile("  \"variants\": {");
        this.writeToBlockstateFile("    \"type=bottom\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"type=double\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + JBlockProperties.getTextureFromName(name) + "\"");
        this.writeToBlockstateFile("      },");
        this.writeToBlockstateFile("    \"type=top\": {");
        this.writeToBlockstateFile("        \"model\": \"" + modID + ":block/" + name + "_top\"");
        this.writeToBlockstateFile("      }");
        this.writeToBlockstateFile("  }");
        this.writeToBlockstateFile("}");
    }

    public void writerInit() {
        try {
            this.itemModelWriter.close();
            this.blockModelWriter.close();
            this.blockTopModelWriter.close();
            this.blockstateWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToItemModelFile(String text) {
        try {
            this.itemModelWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockModelFile(BufferedWriter writer, String text) {
        try {
            writer.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToBlockstateFile(String text) {
        try {
            this.blockstateWriter.write(text + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

