/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.data.recipe;

import java.util.concurrent.CompletableFuture;
import net.jitl.core.data.JRecipeProvider;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class JRecipeRegistry
extends JRecipeProvider {
    public JRecipeRegistry(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    @Override
    public void buildRecipes(RecipeOutput recipeConsumer) {
        this.buildBlockRecipes(recipeConsumer);
        this.buildItemRecipes(recipeConsumer);
        this.buildWoodTypes(recipeConsumer);
        this.buildQuartzTypes(recipeConsumer);
        this.buildSmithingRecipes(recipeConsumer);
    }

    public void buildBlockRecipes(RecipeOutput recipeConsumer) {
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.GREEN_GEM.get(), (ItemLike)JBlocks.GREEN_GEM_BLOCK.get());
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.PURPLE_GEM.get(), (ItemLike)JBlocks.PURPLE_GEM_BLOCK.get());
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.BLUE_GEM.get(), (ItemLike)JBlocks.BLUE_GEM_BLOCK.get());
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.YELLOW_GEM.get(), (ItemLike)JBlocks.YELLOW_GEM_BLOCK.get());
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JBlocks.GREEN_GEM_BLOCK.get(), (ItemLike)JItems.GREEN_GEM.get(), 9);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JBlocks.PURPLE_GEM_BLOCK.get(), (ItemLike)JItems.PURPLE_GEM.get(), 9);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JBlocks.BLUE_GEM_BLOCK.get(), (ItemLike)JItems.BLUE_GEM.get(), 9);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JBlocks.YELLOW_GEM_BLOCK.get(), (ItemLike)JItems.YELLOW_GEM.get(), 9);
        this.addOreBlockRecipe(recipeConsumer, (ItemLike)JItems.IRIDIUM_NUGGET.get(), (ItemLike)JBlocks.IRIDIUM_BLOCK.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)JBlocks.IRIDIUM_ORE.get(), (ItemLike)JItems.IRIDIUM_NUGGET.get());
        this.addOreBlockRecipe(recipeConsumer, (ItemLike)JItems.ENDERILLIUM_SHARD.get(), (ItemLike)JBlocks.ENDERILLIUM_BLOCK.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)JBlocks.ENDERILLIUM_ORE.get(), (ItemLike)JItems.ENDERILLIUM_SHARD.get());
        this.addOreBlockRecipe(recipeConsumer, (ItemLike)JItems.ASH.get(), (ItemLike)JBlocks.ASHUAL_BLOCK.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)JBlocks.ASHUAL_ORE.get(), (ItemLike)JItems.ASH.get());
        this.addOreBlockRecipe(recipeConsumer, (ItemLike)JItems.PERIDOT_GEMSTONE.get(), (ItemLike)JBlocks.PERIDOT_BLOCK.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)JBlocks.PERIDOT_ORE.get(), (ItemLike)JItems.PERIDOT_GEMSTONE.get());
        this.addOreBlockRecipe(recipeConsumer, (ItemLike)JItems.RIMESTONE.get(), (ItemLike)JBlocks.RIMESTONE_BLOCK.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)JBlocks.RIMESTONE_ORE.get(), (ItemLike)JItems.RIMESTONE.get());
        this.addOreBlockRecipe(recipeConsumer, (ItemLike)JItems.BLAZIUM_INGOT.get(), (ItemLike)JBlocks.BLAZIUM_BLOCK.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)JItems.RAW_BLAZIUM.get(), (ItemLike)JItems.BLAZIUM_INGOT.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)JBlocks.FIRESTONE_ORE.get(), (ItemLike)JItems.FIRESTONE_CLUMP.get());
        this.addOreBlockRecipe(recipeConsumer, (ItemLike)JItems.FIRESTONE_CLUMP.get(), (ItemLike)JBlocks.FIRESTONE_BLOCK.get());
        this.addOreDefaultItems(recipeConsumer, JRecipeProvider.RecipePrefix.SHADIUM, (ItemLike)JBlocks.SHADIUM_BLOCK.get(), (ItemLike)JBlocks.SHADIUM_ORE.get(), (ItemLike)JBlocks.DEEPSLATE_SHADIUM_ORE.get(), (ItemLike)JItems.RAW_SHADIUM.get(), (ItemLike)JItems.SHADIUM_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreDefaultItems(recipeConsumer, JRecipeProvider.RecipePrefix.SAPPHIRE, (ItemLike)JBlocks.SAPPHIRE_BLOCK.get(), (ItemLike)JBlocks.SAPPHIRE_ORE.get(), (ItemLike)JBlocks.DEEPSLATE_SAPPHIRE_ORE.get(), null, (ItemLike)JItems.SAPPHIRE.get(), (ItemLike)Items.STICK);
        this.addOreDefaultItems(recipeConsumer, JRecipeProvider.RecipePrefix.LUNIUM, (ItemLike)JBlocks.LUNIUM_BLOCK.get(), (ItemLike)JBlocks.LUNIUM_ORE.get(), (ItemLike)JBlocks.DEEPSLATE_LUNIUM_ORE.get(), (ItemLike)JItems.LUNIUM_POWDER.get(), (ItemLike)JItems.LUNIUM_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreDefaultItems(recipeConsumer, JRecipeProvider.RecipePrefix.BLOODCRUST, (ItemLike)JBlocks.BLOODCRUST_BLOCK.get(), (ItemLike)JBlocks.BLOODCRUST_ORE.get(), null, (ItemLike)JItems.RAW_BLOODCRUST.get(), (ItemLike)JItems.BLOODCRUST_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreDefaultItems(recipeConsumer, JRecipeProvider.RecipePrefix.CELESTIUM, (ItemLike)JBlocks.CELESTIUM_BLOCK.get(), (ItemLike)JBlocks.CELESTIUM_ORE.get(), null, (ItemLike)JItems.CELESTIUM_GEMSTONE.get(), (ItemLike)JItems.CELESTIUM_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreNoArmorItems(recipeConsumer, JRecipeProvider.RecipePrefix.KORITE, (ItemLike)JBlocks.KORITE_BLOCK.get(), (ItemLike)JBlocks.KORITE_ORE.get(), null, (ItemLike)JItems.KORITE_GEMSTONE.get(), (ItemLike)JItems.KORITE_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreNoArmorItems(recipeConsumer, JRecipeProvider.RecipePrefix.STORON, (ItemLike)JBlocks.STORON_BLOCK.get(), (ItemLike)JBlocks.STORON_ORE.get(), null, (ItemLike)JItems.STORON_GEMSTONE.get(), (ItemLike)JItems.STORON_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreNoArmorItems(recipeConsumer, JRecipeProvider.RecipePrefix.MEKYUM, (ItemLike)JBlocks.MEKYUM_BLOCK.get(), (ItemLike)JBlocks.MEKYUM_ORE.get(), null, (ItemLike)JItems.MEKYUM_GEMSTONE.get(), (ItemLike)JItems.MEKYUM_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreDefaultItems(recipeConsumer, JRecipeProvider.RecipePrefix.FLAIRIUM, (ItemLike)JBlocks.FLAIRIUM_BLOCK.get(), (ItemLike)JBlocks.FLAIRIUM_ORE.get(), null, null, (ItemLike)JItems.FLAIRIUM_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreNoArmorItems(recipeConsumer, JRecipeProvider.RecipePrefix.DES, (ItemLike)JBlocks.DES_BLOCK.get(), (ItemLike)JBlocks.DES_ORE.get(), null, null, (ItemLike)JItems.DES_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreNoArmorItems(recipeConsumer, JRecipeProvider.RecipePrefix.GORBITE, (ItemLike)JBlocks.GORBITE_BLOCK.get(), (ItemLike)JBlocks.GORBITE_ORE.get(), null, null, (ItemLike)JItems.GORBITE_GEM.get(), (ItemLike)Items.STICK);
        this.addOreDefaultItems(recipeConsumer, JRecipeProvider.RecipePrefix.ORBADITE, (ItemLike)JBlocks.ORBADITE_BLOCK.get(), (ItemLike)JBlocks.ORBADITE_ORE.get(), null, (ItemLike)JItems.RAW_ORBADITE.get(), (ItemLike)JItems.ORBADITE_INGOT.get(), (ItemLike)Items.STICK);
        this.addOreNoArmorItems(recipeConsumer, JRecipeProvider.RecipePrefix.SOULSTONE, (ItemLike)JBlocks.SOULSTONE_BLOCK.get(), null, null, null, (ItemLike)JItems.SOULSTONE.get(), (ItemLike)JItems.OBSIDIAN_STICK.get());
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "dsd", "iii", 'i', (ItemLike)JBlocks.BLOOD_ROCK.get(), 'd', (ItemLike)JItems.BLOODCRUST_INGOT.get(), 's', (ItemLike)JItems.BLEEDSTONE.get(), (ItemLike)JBlocks.SUMMONING_TABLE.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "dd", "dd", 'd', (ItemLike)JBlocks.BLOOD_ROCK.get(), (ItemLike)JBlocks.BLOOD_BRICKS.get(), 4);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "dd", "dd", 'd', (ItemLike)JBlocks.BLOOD_BRICKS.get(), (ItemLike)JBlocks.CARVED_BLOOD_ROCK.get(), 4);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "ddd", "did", "ddd", 'i', (ItemLike)Blocks.GLOWSTONE, 'd', (ItemLike)JBlocks.BLOOD_ROCK.get(), (ItemLike)JBlocks.BLOOD_LAMP.get(), 4);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "ddd", "did", "ddd", 'i', (ItemLike)JBlocks.BLOOD_ROCK.get(), 'd', (ItemLike)JItems.BOIL_POWDER.get(), (ItemLike)JBlocks.OBELISK.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "ddd", "did", "ddd", 'd', (ItemLike)JBlocks.BLOOD_ROCK.get(), 'i', (ItemLike)JItems.BALMY_TEARDROP.get(), (ItemLike)JBlocks.BLOOD_RUNE.get(), 4);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "dd", "dd", 'd', (ItemLike)JBlocks.CARVED_BLOOD_ROCK.get(), (ItemLike)JBlocks.BLOOD_PILLAR.get(), 4);
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.EUCA_PORTAL_GEM.get(), (ItemLike)JBlocks.EUCA_PORTAL_FRAME.get(), 10);
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.DEPTHS_PORTAL_GEM.get(), (ItemLike)JBlocks.DEPTHS_PORTAL_FRAME.get(), 12);
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.CORBA_PORTAL_GEM.get(), (ItemLike)JBlocks.CORBA_PORTAL_FRAME.get(), 12);
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.TERRANIA_PORTAL_GEM.get(), (ItemLike)JBlocks.TERRANIAN_PORTAL_FRAME.get(), 10);
        this.add3x3Recipe(recipeConsumer, (ItemLike)JItems.CLOUDIA_PORTAL_GEM.get(), (ItemLike)JBlocks.CLOUDIA_PORTAL_FRAME.get(), 10);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.BUILDING_BLOCKS, "iii", "idi", "iii", 'i', (ItemLike)Items.SNOWBALL, 'd', (ItemLike)Items.DIAMOND, (ItemLike)JBlocks.FROZEN_PORTAL_FRAME.get(), 10);
        this.add2x2Recipe(recipeConsumer, (ItemLike)JItems.SMITHSTONE.get(), (ItemLike)JBlocks.SMITHSTONE_BLOCK.get(), true);
        this.add2x2Recipe(recipeConsumer, (ItemLike)JItems.BLEEDSTONE.get(), (ItemLike)JBlocks.BLEEDSTONE_BLOCK.get(), true);
    }

    public void buildItemRecipes(RecipeOutput recipeConsumer) {
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "iii", "idi", "iii", 'i', (ItemLike)Items.GOLD_INGOT, 'd', (ItemLike)Items.DIAMOND, (ItemLike)JItems.FLAME_COIN.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", "did", "ddd", 'd', (ItemLike)JItems.STONE_CLUMP.get(), 'i', (ItemLike)Blocks.STONE, (ItemLike)JItems.REINFORCED_STONE_INGOT.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", "did", "ddd", 'd', (ItemLike)JItems.STONE_CLUMP.get(), 'i', (ItemLike)JItems.CAVE_CRYSTAL.get(), (ItemLike)JItems.REINFORCED_CRYSTAL_INGOT.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "iei", "iii", 'i', (ItemLike)JItems.MAGIC_DUST.get(), 'e', (ItemLike)Items.ENDER_PEARL, (ItemLike)JItems.CRYSTAL_BALL.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.COMBAT, "ddd", "did", "ddd", 'd', (ItemLike)JItems.DEMONIC_DUST.get(), 'i', (ItemLike)JItems.CRYSTAL_BALL.get(), (ItemLike)JItems.DEMONIC_BOMB.get(), 16);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.COMBAT, "ddd", "did", "ddd", 'd', (ItemLike)JItems.MAGIC_DUST.get(), 'i', (ItemLike)JItems.CRYSTAL_BALL.get(), (ItemLike)JItems.MAGIC_BOMB.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", "ddd", "ddd", 'd', (ItemLike)JItems.CAVE_DUST.get(), (ItemLike)JItems.STONE_CLUMP.get(), 4, "_2");
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", "ddd", "ddd", 'd', (ItemLike)Blocks.STONE, (ItemLike)JItems.STONE_CLUMP.get(), 16);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", "did", "ddd", 'd', (ItemLike)JItems.WITHIC_DUST.get(), 'i', (ItemLike)JItems.LOST_SOUL.get(), (ItemLike)JItems.WITHIC_SOUL.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", "did", "ddd", 'd', (ItemLike)JItems.BLOOD.get(), 'i', (ItemLike)JItems.LOST_SOUL.get(), (ItemLike)JItems.CONCENTRATED_BLOOD.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "dgd", "did", "dgd", 'd', (ItemLike)JItems.FLAMING_SPRING.get(), 'i', (ItemLike)JItems.FLAMING_SPROCKET.get(), 'g', (ItemLike)Items.GOLD_INGOT, (ItemLike)JItems.NETHER_KEY.get(), 1);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JItems.DEMONIC_BONE.get(), (ItemLike)JItems.DEMONIC_DUST.get(), 5);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JItems.SMITHSTONE.get(), (ItemLike)JItems.SMITHSTONE_DUST.get(), 4);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JItems.BLEEDSTONE.get(), (ItemLike)JItems.BLEEDSTONE_DUST.get(), 4);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JItems.BLEEDSTONE_DUST.get(), (ItemLike)JItems.SMITHSTONE_DUST.get(), (ItemLike)JItems.SOULSTONE.get(), 1);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JItems.SHADIUM_INGOT.get(), (ItemLike)Items.DIAMOND, (ItemLike)JItems.DARK_GEM.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", 'd', (ItemLike)JItems.BLOODCRUST_INGOT.get(), (ItemLike)JItems.BLOODCRUST_CLUMP.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", 'd', (ItemLike)JItems.SHADIUM_INGOT.get(), (ItemLike)JItems.SHADIUM_CLUMP.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "ddd", 'd', (ItemLike)JItems.LUNIUM_INGOT.get(), (ItemLike)JItems.LUNIUM_CLUMP.get(), 1);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JItems.BLOODCRUST_CLUMP.get(), (ItemLike)JItems.SHADIUM_CLUMP.get(), (ItemLike)JItems.LUNIUM_CLUMP.get(), (ItemLike)JItems.SPAWNER_CLUMP.get(), 1);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JItems.EUCA_PORTAL_PIECE_1.get(), (ItemLike)JItems.EUCA_PORTAL_PIECE_2.get(), (ItemLike)JItems.EUCA_PORTAL_PIECE_3.get(), (ItemLike)JItems.EUCA_PORTAL_GEM.get(), 9);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)Items.ENDER_EYE, (ItemLike)JItems.DEMONIC_DUST.get(), (ItemLike)JItems.DEMONIC_EYE.get(), 1);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)Items.ENDER_EYE, (ItemLike)JItems.SENTRY_STONE.get(), (ItemLike)JItems.SENTRY_EYE.get(), 1);
        this.addShapelessRecipe(recipeConsumer, RecipeCategory.MISC, (ItemLike)JItems.FLAME_COIN.get(), (ItemLike)Items.BOOK, (ItemLike)JItems.RECIPE_BOOK.get(), 1);
        this.addSwordRecipe(recipeConsumer, (ItemLike)JItems.BLOODCRUST_INGOT.get(), (ItemLike)JItems.WITHIC_DUST.get(), (ItemLike)JItems.WITHIC_BLADE.get());
        this.addSwordRecipe(recipeConsumer, (ItemLike)JItems.STONE_STICK.get(), (ItemLike)JItems.REINFORCED_STONE_INGOT.get(), (ItemLike)JItems.REINFORCED_STONE_SWORD.get());
        this.addSwordRecipe(recipeConsumer, (ItemLike)JItems.STONE_STICK.get(), (ItemLike)JItems.REINFORCED_CRYSTAL_INGOT.get(), (ItemLike)JItems.REINFORCED_CRYSTAL_SWORD.get());
        this.addSwordRecipe(recipeConsumer, (ItemLike)JItems.STONE_CLUMP.get(), (ItemLike)JItems.FLORO_PEDAL.get(), (ItemLike)JItems.PEDAL_SWORD.get());
        this.addSwordRecipe(recipeConsumer, (ItemLike)Blocks.STONE, (ItemLike)JItems.CAVE_CRYSTAL.get(), (ItemLike)JItems.CRYSTAL_BLADE.get());
        this.addSwordRecipe(recipeConsumer, (ItemLike)JItems.DEMONIC_BONE.get(), (ItemLike)JItems.DEMONIC_DUST.get(), (ItemLike)JItems.DEMONIC_SWORD.get());
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)JItems.SPAWNER_CLUMP.get(), (ItemLike)JItems.SPAWNER_BAR.get());
        JRecipeRegistry.threeByThreePacker((RecipeOutput)recipeConsumer, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)JBlocks.AIRROOT_MELON.get()), (ItemLike)((ItemLike)JItems.AIRMELON.get()));
        this.addSmeltingAndBlastingRecipe(recipeConsumer, (ItemLike)Items.ROTTEN_FLESH, (ItemLike)Items.LEATHER);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "pep", "eye", "pep", 'e', (ItemLike)JItems.ENDERILLIUM_SHARD, 'p', (ItemLike)Items.ENDER_PEARL, 'y', (ItemLike)Items.ENDER_EYE, (ItemLike)JItems.MINERS_PEARL.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, "pep", "eye", "pep", 'e', (ItemLike)JItems.DARK_ORB, 'p', (ItemLike)JItems.LIGHT_TERRANIAN_SOIL, 'y', (ItemLike)JItems.MAGIC_DUST, (ItemLike)JItems.MOON_OF_ETERNAL_NIGHT.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.MISC, " w ", "www", " w ", 'w', (ItemLike)Items.WHEAT, (ItemLike)JItems.PET_FOOD, 4);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.COMBAT, "  e", " s ", "s  ", 's', (ItemLike)JItems.STONE_STICK.get(), 'e', (ItemLike)Items.ENDER_PEARL, (ItemLike)JItems.STAFF_BASE.get(), 1);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.COMBAT, "s", "s", 's', (ItemLike)Blocks.STONE, (ItemLike)JItems.STONE_STICK.get(), 2);
        this.addShapedRecipe(recipeConsumer, RecipeCategory.COMBAT, " ii", "igi", "ib ", 'i', (ItemLike)Items.IRON_INGOT, 'g', (ItemLike)Items.GUNPOWDER, 'b', (TagKey<Item>)ItemTags.BUTTONS, (ItemLike)JItems.GUN_BASE.get(), 1);
    }

    public void buildWoodTypes(RecipeOutput consumer) {
        this.addWoodType(consumer, JBlocks.EUCA_GOLD_LOG, JBlocks.EUCA_GOLD_PLANKS, JBlocks.EUCA_GOLD_STAIRS, JBlocks.EUCA_GOLD_SLAB, JBlocks.EUCA_GOLD_FENCE, JBlocks.EUCA_GOLD_FENCE_GATE, JBlocks.EUCA_GOLD_TRAP_DOOR, JBlocks.EUCA_GOLD_PRESSURE_PLATE, JBlocks.EUCA_GOLD_DOOR, JBlocks.EUCA_GOLD_BUTTON, JItems.GOLDEN_EUCA_BOAT);
        this.addWoodType(consumer, JBlocks.EUCA_BROWN_LOG, JBlocks.EUCA_BROWN_PLANKS, JBlocks.EUCA_BROWN_STAIRS, JBlocks.EUCA_BROWN_SLAB, JBlocks.EUCA_BROWN_FENCE, JBlocks.EUCA_BROWN_FENCE_GATE, JBlocks.EUCA_BROWN_TRAP_DOOR, JBlocks.EUCA_BROWN_PRESSURE_PLATE, JBlocks.EUCA_BROWN_DOOR, JBlocks.EUCA_BROWN_BUTTON, JItems.BROWN_EUCA_BOAT);
        this.addWoodType(consumer, JBlocks.FROZEN_LOG, JBlocks.FROZEN_PLANKS, JBlocks.FROZEN_STAIRS, JBlocks.FROZEN_SLAB, JBlocks.FROZEN_FENCE, JBlocks.FROZEN_FENCE_GATE, JBlocks.FROZEN_TRAP_DOOR, JBlocks.FROZEN_PRESSURE_PLATE, JBlocks.FROZEN_DOOR, JBlocks.FROZEN_BUTTON, JItems.FROZEN_BOAT);
        this.addWoodType(consumer, JBlocks.BURNED_BARK, JBlocks.BURNED_PLANKS, JBlocks.BURNED_STAIRS, JBlocks.BURNED_SLAB, JBlocks.BURNED_FENCE, JBlocks.BURNED_FENCE_GATE, JBlocks.BURNED_TRAP_DOOR, JBlocks.BURNED_PRESSURE_PLATE, JBlocks.BURNED_DOOR, JBlocks.BURNED_BUTTON, JItems.BURNED_BOAT);
        this.addWoodType(consumer, JBlocks.DEPTHS_LOG, JBlocks.DEPTHS_PLANKS, JBlocks.DEPTHS_STAIRS, JBlocks.DEPTHS_SLAB, JBlocks.DEPTHS_FENCE, JBlocks.DEPTHS_FENCE_GATE, JBlocks.DEPTHS_TRAP_DOOR, JBlocks.DEPTHS_PRESSURE_PLATE, JBlocks.DEPTHS_DOOR, JBlocks.DEPTHS_BUTTON, JItems.DEPTHS_BOAT);
        this.addWoodType(consumer, JBlocks.CORBA_LOG, JBlocks.CORBA_PLANKS, JBlocks.CORBA_STAIRS, JBlocks.CORBA_SLAB, JBlocks.CORBA_FENCE, JBlocks.CORBA_FENCE_GATE, JBlocks.CORBA_TRAP_DOOR, JBlocks.CORBA_PRESSURE_PLATE, JBlocks.CORBA_DOOR, JBlocks.CORBA_BUTTON, JItems.CORBA_BOAT);
        this.addWoodType(consumer, JBlocks.TERRANIAN_LOG, JBlocks.TERRANIAN_PLANKS, JBlocks.TERRANIAN_STAIRS, JBlocks.TERRANIAN_SLAB, JBlocks.TERRANIAN_POST, JBlocks.TERRANIAN_FENCE_GATE, JBlocks.TERRANIAN_TRAP_DOOR, JBlocks.TERRANIAN_PRESSURE_PLATE, JBlocks.TERRANIAN_DOOR, JBlocks.TERRANIAN_BUTTON, JItems.TERRANIAN_BOAT);
        this.addWoodType(consumer, JBlocks.CLOUDIA_LOG, JBlocks.CLOUDIA_PLANKS, JBlocks.CLOUDIA_STAIRS, JBlocks.CLOUDIA_SLAB, JBlocks.CLOUDIA_FENCE, JBlocks.CLOUDIA_FENCE_GATE, JBlocks.CLOUDIA_TRAP_DOOR, JBlocks.CLOUDIA_PRESSURE_PLATE, JBlocks.CLOUDIA_DOOR, JBlocks.CLOUDIA_BUTTON, JItems.CLOUDIA_BOAT);
    }

    public void buildQuartzTypes(RecipeOutput consumer) {
        this.addQuartzType(consumer, JItems.CRIMSON_QUARTZ, JBlocks.CRIMSON_QUARTZ_ORE, JBlocks.CRIMSON_QUARTZ_BLOCK, JBlocks.SMOOTH_CRIMSON_QUARTZ, JBlocks.CRIMSON_QUARTZ_STAIRS, JBlocks.SMOOTH_CRIMSON_QUARTZ_STAIRS, JBlocks.CRIMSON_QUARTZ_SLAB, JBlocks.SMOOTH_CRIMSON_QUARTZ_SLAB, JBlocks.CRIMSON_QUARTZ_BRICKS, JBlocks.CHISELED_CRIMSON_QUARTZ_BLOCK, JBlocks.CRIMSON_QUARTZ_PILLAR);
        this.addQuartzType(consumer, JItems.WARPED_QUARTZ, JBlocks.WARPED_QUARTZ_ORE, JBlocks.WARPED_QUARTZ_BLOCK, JBlocks.SMOOTH_WARPED_QUARTZ, JBlocks.WARPED_QUARTZ_STAIRS, JBlocks.SMOOTH_WARPED_QUARTZ_STAIRS, JBlocks.WARPED_QUARTZ_SLAB, JBlocks.SMOOTH_WARPED_QUARTZ_SLAB, JBlocks.WARPED_QUARTZ_BRICKS, JBlocks.CHISELED_WARPED_QUARTZ_BLOCK, JBlocks.WARPED_QUARTZ_PILLAR);
    }

    public void buildSmithingRecipes(RecipeOutput recipeConsumer) {
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_HELMET, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_HELMET.get());
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_CHESTPLATE, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_CHEST.get());
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_LEGGINGS, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_LEGS.get());
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_BOOTS, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_BOOTS.get());
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_SWORD, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_SWORD.get());
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_AXE, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_AXE.get());
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_PICKAXE, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_PICKAXE.get());
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_SHOVEL, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_SHOVEL.get());
        this.addSmithingRecipe(recipeConsumer, (ItemLike)Items.DIAMOND_HOE, (ItemLike)JItems.LUNIUM_INGOT.get(), (Item)JItems.LUNIUM_HOE.get());
    }
}

