/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.helper;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class TooltipFiller {
    private final List<Component> tooltip;
    private final String key;
    private int line = 0;
    private final int startPoint;

    public TooltipFiller(List<Component> text, String itemKey) {
        this.tooltip = text;
        this.key = itemKey;
        this.startPoint = -1;
    }

    public TooltipFiller(List<Component> text, String itemKey, int start) {
        this.tooltip = text;
        this.key = itemKey;
        this.startPoint = start;
    }

    public void addTooltip(ChatFormatting color) {
        if (this.startPoint == -1) {
            this.tooltip.add((Component)Component.translatable((String)("jitl.tooltip." + this.key + "." + this.line++)).withStyle(color));
        } else {
            this.tooltip.add(this.startPoint + this.line, (Component)Component.translatable((String)("jitl.tooltip." + this.key + "." + this.line++)).withStyle(color));
        }
    }

    public void addOverview() {
        this.addTooltip(ChatFormatting.GOLD);
    }

    public void addDetail() {
        this.addTooltip(ChatFormatting.AQUA);
    }

    public void addDrawback() {
        this.addTooltip(ChatFormatting.RED);
    }

    public void addValue(Object ... values) {
        this.tooltip.add((Component)Component.translatable((String)("jitl.tooltip." + this.key + "." + this.line++), (Object[])values).withStyle(ChatFormatting.GREEN));
    }

    public void addBreak() {
        this.tooltip.add((Component)Component.empty());
    }
}

