/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.init.compat;

import jeresources.api.IDungeonRegistry;
import jeresources.api.IJERAPI;
import jeresources.api.IPlantRegistry;
import jeresources.api.IWorldGenRegistry;
import jeresources.api.conditionals.Conditional;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionSquare;
import jeresources.api.drop.LootDrop;
import jeresources.api.drop.PlantDrop;
import jeresources.compatibility.api.JERAPI;
import net.jitl.core.init.JITL;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.storage.loot.LootTable;

public class JERCompat {
    public static void init() {
        IDungeonRegistry chest;
        IPlantRegistry plants;
        IJERAPI api = JERAPI.getInstance();
        IWorldGenRegistry worldGen = api.getWorldGenRegistry();
        if (worldGen != null) {
            worldGen.register(new ItemStack((ItemLike)JBlocks.SAPPHIRE_ORE.get()), new ItemStack((ItemLike)JBlocks.DEEPSLATE_SAPPHIRE_ORE.get()), (DistributionBase)new DistributionSquare(5, 7, -80, 48), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.SAPPHIRE.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.IRIDIUM_ORE.get()), new ItemStack((ItemLike)JBlocks.DEEPSLATE_IRIDIUM_ORE.get()), (DistributionBase)new DistributionSquare(5, 7, -80, 48), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.IRIDIUM_NUGGET.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.SHADIUM_ORE.get()), new ItemStack((ItemLike)JBlocks.DEEPSLATE_SHADIUM_ORE.get()), (DistributionBase)new DistributionSquare(5, 7, -80, 48), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.RAW_SHADIUM.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.LUNIUM_ORE.get()), new ItemStack((ItemLike)JBlocks.DEEPSLATE_LUNIUM_ORE.get()), (DistributionBase)new DistributionSquare(5, 7, -80, 48), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.LUNIUM_POWDER.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.BLOODCRUST_ORE.get()), (DistributionBase)new DistributionSquare(4, 7, -80, 256), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.RAW_BLOODCRUST.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.BLEEDSTONE_BLOCK.get()), (DistributionBase)new DistributionSquare(2, 7, 0, 256), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.BLEEDSTONE.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.SMITHSTONE_BLOCK.get()), (DistributionBase)new DistributionSquare(2, 7, 0, 256), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.SMITHSTONE.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.FIRESTONE_ORE.get()), (DistributionBase)new DistributionSquare(10, 7, -64, 256), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.FIRESTONE_CLUMP.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.CRIMSON_QUARTZ_ORE.get()), (DistributionBase)new DistributionSquare(10, 7, -64, 256), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.CRIMSON_QUARTZ.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.WARPED_QUARTZ_ORE.get()), (DistributionBase)new DistributionSquare(10, 7, -64, 256), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.WARPED_QUARTZ.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.ENDERILLIUM_ORE.get()), (DistributionBase)new DistributionSquare(7, 7, -64, 128), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.ENDERILLIUM_SHARD.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.ASHUAL_ORE.get()), (DistributionBase)new DistributionSquare(12, 7, 0, 256), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.ASH.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.BLAZIUM_ORE.get()), (DistributionBase)new DistributionSquare(12, 7, 0, 256), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.RAW_BLAZIUM.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.CELESTIUM_ORE.get()), (DistributionBase)new DistributionSquare(7, 7, -64, 128), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.CELESTIUM_GEMSTONE.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.MEKYUM_ORE.get()), (DistributionBase)new DistributionSquare(7, 7, -64, 128), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.MEKYUM_GEMSTONE.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.STORON_ORE.get()), (DistributionBase)new DistributionSquare(7, 7, -64, 128), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.STORON_GEMSTONE.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.KORITE_ORE.get()), (DistributionBase)new DistributionSquare(7, 7, -64, 128), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.RAW_ORBADITE.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.RIMESTONE_ORE.get()), (DistributionBase)new DistributionSquare(12, 7, 0, 256), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.RIMESTONE.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.PERIDOT_ORE.get()), (DistributionBase)new DistributionSquare(12, 7, 0, 256), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.PERIDOT_GEMSTONE.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.DES_ORE.get()), (DistributionBase)new DistributionSquare(7, 7, 0, 256), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JBlocks.DES_ORE.get()), 1.0f)});
            worldGen.register(new ItemStack((ItemLike)JBlocks.FLAIRIUM_ORE.get()), (DistributionBase)new DistributionSquare(7, 7, 0, 256), new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JBlocks.FLAIRIUM_ORE.get()), 1.0f)});
            worldGen.register(new ItemStack((ItemLike)JBlocks.ORBADITE_ORE.get()), (DistributionBase)new DistributionSquare(12, 7, 0, 256), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.RAW_ORBADITE.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.GORBITE_ORE.get()), (DistributionBase)new DistributionSquare(12, 7, 0, 256), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.GORBITE_GEM.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
            worldGen.register(new ItemStack((ItemLike)JBlocks.LUNITE_ORE.get()), (DistributionBase)new DistributionSquare(12, 7, 0, 256), true, new LootDrop[]{new LootDrop(new ItemStack((ItemLike)JItems.LUNITE_CHUNK.get()), 1, 5, new Conditional[]{Conditional.affectedByFortune})});
        }
        if ((plants = api.getPlantRegistry()) != null) {
            JERCompat.addPlant(plants, (Item)JItems.FLORO_SEEDS.get(), (Item)JItems.FLORO_PEDAL.get(), (BushBlock)JBlocks.FLORO_PEDAL_CROP.get());
            JERCompat.addPlant(plants, (Item)JItems.TOMATO_SEEDS.get(), (Item)JItems.TOMATO.get(), (BushBlock)JBlocks.TOMATO_CROP.get());
            JERCompat.addBerryBush(plants, (Item)JItems.REDCURRANT_BERRY.get(), (BushBlock)JBlocks.REDCURRANT_BUSH.get(), (Block)JBlocks.GRASSY_PERMAFROST.get());
            JERCompat.addBerryBush(plants, (Item)JItems.BRADBERRY.get(), (BushBlock)JBlocks.BRADBERRY_BUSH.get(), Blocks.GRASS_BLOCK);
            JERCompat.addPlant(plants, (Item)JItems.ZATPEDAL_SEEDS.get(), (Item)JItems.ZATPEDAL.get(), (BushBlock)JBlocks.ZATPEDAL_CROP.get(), (Block)JBlocks.GOLDITE_FARMLAND.get());
            JERCompat.addPlant(plants, (Item)JItems.SPINEBERRY_SEEDS.get(), (Item)JItems.SPINEBERRIES.get(), (BushBlock)JBlocks.SPINEBERRY_CROP.get(), (Block)JBlocks.GOLDITE_FARMLAND.get());
            JERCompat.addPlant(plants, (Item)JItems.CRAKEBULB_SEEDS.get(), (Item)JItems.CRAKEBULB.get(), (BushBlock)JBlocks.CRAKEBULB_CROP.get(), (Block)JBlocks.DEPTHS_FARMLAND.get());
            JERCompat.addPlant(plants, (Item)JItems.CRACKENCANE_SEEDS.get(), (Item)JItems.CRACKENCANE.get(), (BushBlock)JBlocks.CRACKENCANE_CROP.get(), (Block)JBlocks.DEPTHS_FARMLAND.get());
            JERCompat.addPlant(plants, (Item)JItems.CORVEGGIES.get(), (Item)JItems.CORVEGGIES.get(), (BushBlock)JBlocks.CORVEGGIES_CROP.get(), (Block)JBlocks.CORBA_FARMLAND.get());
            JERCompat.addPlant(plants, (Item)JItems.GLOWA_SEEDS.get(), (Item)JItems.GLOWA.get(), (BushBlock)JBlocks.GLOWA_CROP.get(), (Block)JBlocks.CORBA_FARMLAND.get());
        }
        if ((chest = api.getDungeonRegistry()) != null) {
            chest.registerChest("Alloy Mender's House", JERCompat.getChestLootTable("alloy_mender_house"));
            chest.registerChest("Ancient Loot Chests", JERCompat.getChestLootTable("ancient_loot"));
            chest.registerChest("Senterian Bar Dungeon Room Chests", JERCompat.getChestLootTable("bars_senterian_dungeon"));
            chest.registerChest("Boiling Point Dungeon Chests", JERCompat.getChestLootTable("boil_dungeon"));
            chest.registerChest("Cloudia Chests", JERCompat.getChestLootTable("cloudia"));
            chest.registerChest("Corba Village Chests", JERCompat.getChestLootTable("corba_village"));
            chest.registerChest("Depths Dungeon Chests", JERCompat.getChestLootTable("depths_dungeon"));
            chest.registerChest("Depths Village Chests", JERCompat.getChestLootTable("depths_village"));
            chest.registerChest("Euca Palace Chests", JERCompat.getChestLootTable("euca_palace"));
            chest.registerChest("Goldite Sphere Dungeon Chests", JERCompat.getChestLootTable("goldite_dungeon"));
            chest.registerChest("Guardian Tower Chests", JERCompat.getChestLootTable("guardian_tower"));
            chest.registerChest("Locked Guardian Tower Chests", JERCompat.getChestLootTable("guardian_tower_locked"));
            chest.registerChest("Hellbot Structure Chests", JERCompat.getChestLootTable("hellbot_spawner"));
            chest.registerChest("Hellwing Structure Chests", JERCompat.getChestLootTable("hellwing_tower"));
            chest.registerChest("Rockite Dungeon Locked Chests", JERCompat.getChestLootTable("locked_rockite_dungeon"));
            chest.registerChest("Nether Tower Locked Chests", JERCompat.getChestLootTable("nether_tower"));
            chest.registerChest("Rockite Dungeon Chests", JERCompat.getChestLootTable("rockite_dungeon"));
            chest.registerChest("Senterian Dungeon Chests", JERCompat.getChestLootTable("senterian_dungeon"));
            chest.registerChest("Frozen Spike Dungeon Chests", JERCompat.getChestLootTable("spike_dungeon"));
            chest.registerChest("Terranian Mega Tree Chests", JERCompat.getChestLootTable("terranian_mega_tree"));
            chest.registerChest("Blazier Boss Crystal", JERCompat.getBossLootTable("blazier"));
            chest.registerChest("Calcia Boss Crystal", JERCompat.getBossLootTable("calcia"));
            chest.registerChest("Corallator Boss Crystal", JERCompat.getBossLootTable("corallator"));
            chest.registerChest("Eudor Boss Crystal", JERCompat.getBossLootTable("eudor"));
            chest.registerChest("Frost Golem Boss Crystal", JERCompat.getBossLootTable("frost_golem"));
            chest.registerChest("Logger Boss Crystal", JERCompat.getBossLootTable("logger"));
            chest.registerChest("Okoloo Boss Crystal", JERCompat.getBossLootTable("okoloo"));
            chest.registerChest("Rockite Smasher Boss Crystal", JERCompat.getBossLootTable("rockite_smasher"));
            chest.registerChest("Scale Boss Crystal", JERCompat.getBossLootTable("scale"));
            chest.registerChest("Sentry King Boss Crystal", JERCompat.getBossLootTable("sentry_king"));
            chest.registerChest("Sky Stalker Boss Crystal", JERCompat.getBossLootTable("sky_stalker"));
            chest.registerChest("Soul Watcher Boss Crystal", JERCompat.getBossLootTable("soul_watcher"));
            chest.registerChest("Temple Guardian Boss Crystal", JERCompat.getBossLootTable("temple_guardian"));
            chest.registerChest("Terranian Protector Boss Crystal", JERCompat.getBossLootTable("terranian_protector"));
            chest.registerChest("Thunder Bird Boss Crystal", JERCompat.getBossLootTable("thunder_bird"));
            chest.registerChest("Withering Beast Boss Crystal", JERCompat.getBossLootTable("withering_beast"));
            chest.registerChest("Basic Loot Pouch", JERCompat.getLootTable("loot_basic"));
            chest.registerChest("Gold Loot Pouch", JERCompat.getLootTable("loot_gold"));
            chest.registerChest("Diamond Loot Pouch", JERCompat.getLootTable("loot_diamond"));
            chest.registerChest("Frosty Loot Pouch", JERCompat.getLootTable("loot_frosty_gift"));
            chest.registerChest("Corba Spirit Crystal", JERCompat.getLootTable("spirit_crystal"));
        }
    }

    public static void addPlant(IPlantRegistry reg, Item seeds, Item flower, BushBlock plant) {
        reg.register(new ItemStack((ItemLike)seeds), plant, new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)flower), 1, 1), new PlantDrop(new ItemStack((ItemLike)seeds), 1, 4)});
    }

    public static void addPlant(IPlantRegistry reg, Item seeds, Item flower, BushBlock plant, Block base) {
        reg.registerWithSoil(new ItemStack((ItemLike)seeds), plant, base.defaultBlockState(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)flower), 1, 1), new PlantDrop(new ItemStack((ItemLike)seeds), 1, 4)});
    }

    public static void addBerryBush(IPlantRegistry reg, Item seeds, BushBlock plant, Block base) {
        reg.registerWithSoil(new ItemStack((ItemLike)seeds), plant, base.defaultBlockState(), new PlantDrop[]{new PlantDrop(new ItemStack((ItemLike)seeds), 2, 3)});
    }

    public static ResourceKey<LootTable> getMobLootTable(String name) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)JITL.rl("entities/" + name));
    }

    public static ResourceKey<LootTable> getLootTable(String name) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)JITL.rl("loot/" + name));
    }

    public static ResourceKey<LootTable> getChestLootTable(String name) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)JITL.rl("chests/" + name));
    }

    public static ResourceKey<LootTable> getBossLootTable(String name) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)JITL.rl("boss_crystal/" + name));
    }
}

