/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.core.init.compat.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.jitl.core.helper.EnumSummoningRecipes;
import net.jitl.core.init.compat.emi.JITLEmiPlugin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class SummoningTableEmiRecipe
implements EmiRecipe {
    private static final ResourceLocation RECIPE_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"jitl", (String)"textures/gui/summoning_table_recipe.png");
    private final ResourceLocation id;
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> outputs;

    public SummoningTableEmiRecipe(EnumSummoningRecipes recipe) {
        this.id = ResourceLocation.fromNamespaceAndPath((String)"jitl", (String)("/summoning_table/" + recipe.name().toLowerCase()));
        this.inputs = Arrays.stream(recipe.getInputs()).map(EmiStack::of).collect(Collectors.toList());
        this.outputs = List.of(EmiStack.of((ItemLike)recipe.getOutput()));
    }

    public EmiRecipeCategory getCategory() {
        return JITLEmiPlugin.SUMMONING_TABLE;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 104;
    }

    public int getDisplayHeight() {
        return 54;
    }

    public void addWidgets(WidgetHolder widgets) {
        int xStart = -4;
        int yStart = -4;
        widgets.addTexture(new EmiTexture(RECIPE_BACKGROUND, 0, 0, 112, 62), xStart, yStart);
        int[][] slotPositions = new int[][]{{xStart + 4, yStart + 4}, {xStart + 4, yStart + 22}, {xStart + 40, yStart + 4}, {xStart + 22, yStart + 22}, {xStart + 4, yStart + 40}, {xStart + 40, yStart + 22}, {xStart + 40, yStart + 40}};
        for (int i = 0; i < this.inputs.size(); ++i) {
            SlotWidget slot = new SlotWidget(this.inputs.get(i), slotPositions[i][0], slotPositions[i][1]);
            slot.drawBack(false);
            widgets.add((Widget)slot);
        }
        SlotWidget outputSlot = new SlotWidget((EmiIngredient)this.outputs.getFirst(), xStart + 86, yStart + 22);
        outputSlot.drawBack(false);
        ((SlotWidget)widgets.add((Widget)outputSlot)).recipeContext((EmiRecipe)this);
    }
}

