/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client;

import java.io.IOException;
import java.net.SocketException;
import net.jitl.core.config.JClientConfig;
import net.jitl.core.helper.InternetHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jitl", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientLoginChecker {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (((Boolean)JClientConfig.UPDATE_MESSAGE.get()).booleanValue() && !player.m_9236_().f_46443_) {
            ClientLoginChecker.sendColouredMessage(player, ChatFormatting.GOLD, "[|---------------------------------------------------|]");
            ClientLoginChecker.sendColouredMessage(player, ChatFormatting.GOLD, "[Journey Into the Light]");
            ClientLoginChecker.sendColouredTranslatedMessage(player, ChatFormatting.LIGHT_PURPLE, "jitl.message.thank_you", player.m_5446_());
            ClientLoginChecker.sendColouredTranslatedMessage(player, ChatFormatting.BLUE, "jitl.message.current_version", "2.2.4");
            try {
                if (!InternetHandler.isOnline()) {
                    MutableComponent msg = Component.m_237115_((String)"jitl.message.no_internet");
                    msg.m_130940_(ChatFormatting.RED);
                    player.m_213846_((Component)msg);
                }
                try {
                    if (InternetHandler.isUpdateAvailable() && InternetHandler.isOnline()) {
                        ClientLoginChecker.sendColouredTranslatedMessage(player, ChatFormatting.GREEN, "jitl.message.update_available", InternetHandler.getUpdateVersion());
                    }
                    if (!InternetHandler.isUpdateAvailable() && InternetHandler.isOnline()) {
                        ClientLoginChecker.sendColouredTranslatedMessage(player, ChatFormatting.AQUA, "jitl.message.up_to_date", new Object[0]);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (SocketException e) {
                throw new RuntimeException(e);
            }
            ClientLoginChecker.sendColouredMessage(player, ChatFormatting.GOLD, "[|---------------------------------------------------|]");
        }
    }

    public static void sendColouredTranslatedMessage(Player player, ChatFormatting colour, String translationKey, Object ... args) {
        MutableComponent msg = Component.m_237110_((String)translationKey, (Object[])args);
        msg.m_130940_(colour);
        player.m_213846_((Component)msg);
    }

    public static void sendColouredMessage(Player player, ChatFormatting colour, String key) {
        MutableComponent msg = Component.m_237113_((String)key);
        msg.m_130940_(colour);
        player.m_213846_((Component)msg);
    }
}

