/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.jitl.core.init.JITL;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;

public class BossBarRenderer {
    private static final Map<ResourceLocation, ResourceLocation> BAR_ID_CACHE = new Object2ObjectOpenHashMap();

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, CustomizeGuiOverlayEvent.BossEventProgress.class, BossBarRenderer::render);
    }

    public static void render(CustomizeGuiOverlayEvent.BossEventProgress ev) {
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        GuiGraphics graphics = ev.getGuiGraphics();
        int x = window.m_85445_() / 2 - 91;
        int y = ev.getY();
        LerpingBossEvent bossStatusInfo = ev.getBossEvent();
        assert (mc.f_91073_ != null);
        LivingEntity entity = (LivingEntity)mc.f_91073_.m_142646_().m_142694_(bossStatusInfo.m_18860_());
        if (entity == null || ev.isCanceled() || Minecraft.m_91087_().f_91073_ == null || bossStatusInfo.m_18862_() != BossEvent.BossBarColor.PINK || bossStatusInfo.m_18863_() != BossEvent.BossBarOverlay.NOTCHED_20) {
            return;
        }
        ResourceLocation texture = BAR_ID_CACHE.computeIfAbsent(JITL.getRegistryName(entity.m_6095_()), key -> new ResourceLocation(key.m_135827_(), "textures/gui/bossbars/" + key.m_135815_() + ".png"));
        double healthWidth = entity.m_21223_() / entity.m_21233_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280411_(texture, x, y, 182, 9, 0.0f, 10.0f, 182, 9, 182, 19);
        graphics.m_280411_(texture, x, y, (int)(182.0 * healthWidth), 9, 0.0f, 0.0f, (int)(182.0 * healthWidth), 9, 182, 19);
        BossBarRenderer.drawCenteredString(graphics, mc.f_91062_, entity.m_7755_(), x, y - 9, 255, 255, 255, 255);
        ev.setIncrement(ev.getIncrement() + 5);
        ev.setCanceled(true);
    }

    public static void drawCenteredString(GuiGraphics matrixStack, Font fontRenderer, Component fontIn, float x, float y, int red, int green, int blue, int alpha) {
        FormattedCharSequence ireorderingprocessor = fontIn.m_7532_();
        int color = Math.max(4, alpha) << 24 | red << 16 | green << 8 | blue;
        matrixStack.drawString(fontRenderer, ireorderingprocessor, x - (float)fontRenderer.m_92724_(ireorderingprocessor) / 2.0f + 91.0f, y, color, true);
    }
}

