/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.gui.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.jitl.client.essence.ClientEssence;
import net.jitl.common.capability.essence.PlayerEssence;
import net.jitl.common.capability.essence.PlayerEssenceProvider;
import net.jitl.common.entity.projectile.EssenceArrowEntity;
import net.jitl.common.items.base.JBowItem;
import net.jitl.core.config.JClientConfig;
import net.jitl.core.config.enums.EssencePosition;
import net.jitl.core.helper.IEssenceItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;

@OnlyIn(value=Dist.CLIENT)
public class EssenceBar {
    private static float transparency;
    private static float burnoutTransparency;
    private static final ResourceLocation UNDER_CROSSHAIR_TEXTURE;
    private static final ResourceLocation OVER_EXP_TEXTURE;
    private static final ResourceLocation ABOVE_HUNGER_TEXTURE;

    public static void render(ForgeGui gui, GuiGraphics poseStack, float partialTick, int screenWidth, int screenHeight) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)OVER_EXP_TEXTURE);
        if (player != null && !player.m_7500_() && !player.m_5833_()) {
            player.getCapability(PlayerEssenceProvider.PLAYER_ESSENCE).ifPresent(arg_0 -> EssenceBar.lambda$render$0((Player)player, minecraft, screenHeight, screenWidth, poseStack, arg_0));
        }
    }

    private static boolean instanceOfEssenceItem(Item isEssence) {
        boolean essenceBow = false;
        if (isEssence instanceof JBowItem) {
            JBowItem bow = (JBowItem)isEssence;
            if (bow.effect.contains((Object)EssenceArrowEntity.BowEffects.CONSUMES_ESSENCE)) {
                essenceBow = true;
            }
        }
        return isEssence instanceof IEssenceItem || essenceBow;
    }

    private static ResourceLocation getTextureBasedOnPosition(EssencePosition essencePosition) {
        if (essencePosition == EssencePosition.OVER_EXPERIENCE_BAR) {
            return OVER_EXP_TEXTURE;
        }
        if (essencePosition == EssencePosition.BELOW_CROSSHAIR) {
            return UNDER_CROSSHAIR_TEXTURE;
        }
        return ABOVE_HUNGER_TEXTURE;
    }

    private static int getVehicleMaxHearts(LivingEntity mountEntity) {
        if (mountEntity != null && mountEntity.m_20152_()) {
            float maxHealth = mountEntity.m_21233_();
            int i = (int)(maxHealth + 0.5f) / 2;
            if (i > 30) {
                i = 30;
            }
            return i;
        }
        return 0;
    }

    private static LivingEntity getPlayerVehicleWithHealth(Player player) {
        if (player != null) {
            Entity entity = player.m_20202_();
            if (entity == null) {
                return null;
            }
            if (entity instanceof LivingEntity) {
                return (LivingEntity)entity;
            }
        }
        return null;
    }

    private static /* synthetic */ void lambda$render$0(Player player, Minecraft minecraft, int screenHeight, int screenWidth, GuiGraphics poseStack, PlayerEssence essence) {
        boolean cooldownActive;
        boolean isEssenceUsed;
        float currentEssence = ClientEssence.getCurrentClientEssence();
        float maxEssence = ClientEssence.getMaxClientEssence();
        float cooldown = ClientEssence.getClientEssenceBurnout();
        boolean bl = isEssenceUsed = currentEssence < maxEssence;
        if ((EssenceBar.instanceOfEssenceItem(player.m_21205_().m_41720_()) || isEssenceUsed) && (double)transparency <= 1.0) {
            transparency = (float)((double)transparency + 0.02);
        } else if (transparency > 0.0f) {
            transparency = (float)((double)transparency - 0.02);
        }
        boolean bl2 = cooldownActive = cooldown > 1.0f;
        if (cooldownActive && burnoutTransparency < 1.0f) {
            burnoutTransparency = (float)((double)burnoutTransparency + 0.02);
        } else if (burnoutTransparency > 0.0f) {
            burnoutTransparency = (float)((double)burnoutTransparency - 0.02);
        }
        JClientConfig config = new JClientConfig();
        EssencePosition essencePosition = config.getEssencePosition();
        int yPos = config.getEssenceYPos();
        int xPos = config.getEssenceXPos();
        if (!minecraft.f_91066_.f_92062_ && transparency > 0.0f && !player.m_5833_()) {
            LivingEntity livingentity;
            int vehicalMaxhearts;
            boolean isUnderwater;
            boolean belowCrosshair = essencePosition == EssencePosition.BELOW_CROSSHAIR;
            int crosshairY = screenHeight / 2;
            int crosshairX = screenWidth / 2;
            int y = belowCrosshair ? crosshairY : screenHeight - yPos;
            int x = belowCrosshair ? crosshairX : screenWidth / 2 - xPos;
            boolean aboveHunger = essencePosition == EssencePosition.ABOVE_HUNGER_BAR;
            boolean bl3 = isUnderwater = player.m_204029_(FluidTags.f_13131_) || Math.min(player.m_20146_(), player.m_6062_()) < player.m_6062_();
            if (isUnderwater && aboveHunger) {
                y -= 10;
            }
            if ((vehicalMaxhearts = EssenceBar.getVehicleMaxHearts(livingentity = EssenceBar.getPlayerVehicleWithHealth(player))) > 0 && aboveHunger) {
                int heartRows = (int)Math.ceil((double)vehicalMaxhearts / 10.0) - 1;
                y -= heartRows * 10;
            }
            poseStack.m_280168_().m_85836_();
            if (belowCrosshair) {
                float scale = 0.5f;
                double widthTranslation = (float)screenWidth / 2.0f - 42.0f;
                double heightTranslation = (float)screenHeight / 2.0f + 42.0f;
                poseStack.m_280168_().m_85837_(widthTranslation, heightTranslation, 0.0);
                poseStack.m_280168_().m_85841_(scale, scale, 0.0f);
                poseStack.m_280168_().m_85837_(-widthTranslation, -heightTranslation, 0.0);
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            }
            float addedAlpha = belowCrosshair ? 0.5f : 0.0f;
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)EssenceBar.getTextureBasedOnPosition(essencePosition));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(transparency - addedAlpha));
            boolean renderSmall = essencePosition == EssencePosition.OVER_EXPERIENCE_BAR || essencePosition == EssencePosition.BELOW_CROSSHAIR;
            int barHeight = renderSmall ? 5 : 9;
            int texHeight = renderSmall ? 15 : 27;
            int backgroundVOffset = renderSmall ? 5 : 9;
            int burnoutVOffset = renderSmall ? 10 : 18;
            poseStack.m_280163_(EssenceBar.getTextureBasedOnPosition(essencePosition), x, y, 0.0f, (float)backgroundVOffset, 81, barHeight, 81, texHeight);
            if (cooldownActive) {
                float sin = (float)Math.sin((float)player.f_19797_ / 5.0f) / 2.0f + 0.5f;
                float cooldownFade = Math.min(cooldown, 10.0f) / 10.0f;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(sin * cooldownFade - addedAlpha));
                poseStack.m_280163_(EssenceBar.getTextureBasedOnPosition(essencePosition), x, y, 0.0f, 0.0f, 81, barHeight, 81, texHeight);
            } else {
                int i = (int)(currentEssence / maxEssence * 81.0f);
                poseStack.m_280163_(EssenceBar.getTextureBasedOnPosition(essencePosition), x, y, 0.0f, 0.0f, i, barHeight, 81, texHeight);
            }
            if (burnoutTransparency > 0.0f) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(burnoutTransparency - addedAlpha));
                poseStack.m_280163_(EssenceBar.getTextureBasedOnPosition(essencePosition), x, y, 0.0f, (float)burnoutVOffset, 81, barHeight, 81, texHeight);
            }
            poseStack.m_280168_().m_85849_();
        }
    }

    static {
        UNDER_CROSSHAIR_TEXTURE = new ResourceLocation("jitl", "textures/gui/essence_under_crosshair.png");
        OVER_EXP_TEXTURE = new ResourceLocation("jitl", "textures/gui/essence_over_exp.png");
        ABOVE_HUNGER_TEXTURE = new ResourceLocation("jitl", "textures/gui/essence_over_hunger.png");
    }
}

