/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.jitl.core.helper.EnumSummoningRecipes;
import net.jitl.core.helper.internal.EmptyContainer;
import net.jitl.core.init.JITL;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class JRecipeBookGUI
extends AbstractContainerScreen<EmptyContainer> {
    private PageButton nextButton;
    private PageButton previousButton;
    private final ResourceLocation RECIPE = JITL.rl("textures/gui/summoning_table_recipe.png");
    private final ResourceLocation BACKGROUND = JITL.rl("textures/gui/recipe_book.png");
    public int pageNumber = 0;

    public JRecipeBookGUI(Inventory playerInventory) {
        super((AbstractContainerMenu)new EmptyContainer(), playerInventory, (Component)Component.m_237115_((String)"jitl.recipe_book"));
        this.f_97726_ = 242;
        this.f_97727_ = 216;
    }

    protected void m_7856_() {
        super.m_7856_();
        int w1 = (this.f_96543_ - this.f_97726_) / 2;
        int h1 = (this.f_96544_ - this.f_97727_) / 2;
        int xPos = w1 + 95;
        int yPos = h1 + 198;
        this.nextButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(xPos + 28, yPos, true, button -> this.flipPage(true), true));
        this.previousButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(xPos, yPos, false, button -> this.flipPage(false), true));
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        int maxPages = 5;
        this.nextButton.f_93624_ = true;
        this.previousButton.f_93624_ = true;
        this.nextButton.f_93623_ = this.pageNumber != maxPages;
        this.previousButton.f_93623_ = this.pageNumber != 0;
    }

    protected void flipPage(boolean forward) {
        this.pageNumber = forward ? ++this.pageNumber : --this.pageNumber;
        this.updateButtonVisibility();
    }

    protected void m_7286_(@NotNull GuiGraphics poseStack, float partialTick, int mouseX, int mouseY) {
        this.m_280273_(poseStack);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        poseStack.m_280168_().m_85836_();
        RenderSystem.setShader(GameRenderer::m_172838_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.BACKGROUND);
        poseStack.m_280218_(this.BACKGROUND, x, y, 0, 0, this.f_97726_, this.f_97727_);
        switch (this.pageNumber) {
            case 0: {
                this.page1(poseStack, mouseX, mouseY);
                break;
            }
            case 1: {
                this.page2(poseStack, mouseX, mouseY);
                break;
            }
            case 2: {
                this.page3(poseStack, mouseX, mouseY);
                break;
            }
        }
        poseStack.m_280168_().m_85849_();
        RenderSystem.enableDepthTest();
    }

    public void page1(GuiGraphics stack, int mouseX, int mouseY) {
        int w = 120;
        int x = -3;
        int y = -3;
        this.drawSprite(stack, mouseX, mouseY, x, y, EnumSummoningRecipes.OKOLOO);
        this.drawSprite(stack, mouseX, mouseY, x += w, y, EnumSummoningRecipes.WITHERING_BEAST);
        this.drawSprite(stack, mouseX, mouseY, x -= w, y += 65, EnumSummoningRecipes.CALCIA);
        this.drawSprite(stack, mouseX, mouseY, x += w, y, EnumSummoningRecipes.SOUL_WATCHER);
        this.drawSprite(stack, mouseX, mouseY, x -= w, y += 65, EnumSummoningRecipes.CORALLATOR);
        this.drawSprite(stack, mouseX, mouseY, x += w, y, EnumSummoningRecipes.BLAZIER);
    }

    public void page2(GuiGraphics stack, int mouseX, int mouseY) {
        int w = 120;
        int x = -3;
        int y = -3;
        this.drawSprite(stack, mouseX, mouseY, x, y, EnumSummoningRecipes.THUNDERBIRD);
        this.drawSprite(stack, mouseX, mouseY, x += w, y, EnumSummoningRecipes.SCALE);
        this.drawSprite(stack, mouseX, mouseY, x -= w, y += 65, EnumSummoningRecipes.LOGGER);
        this.drawSprite(stack, mouseX, mouseY, x += w, y, EnumSummoningRecipes.SENTRY_KING);
        this.drawSprite(stack, mouseX, mouseY, x -= w, y += 65, EnumSummoningRecipes.TERRASTAR);
        x += w;
    }

    private void page3(GuiGraphics poseStack, int mouseX, int mouseY) {
        int w = 120;
        int x = -3;
        int y = -3;
    }

    public void drawSprite(GuiGraphics matrixStack, int mouseX, int mouseY, int x, int y, EnumSummoningRecipes recipe) {
        int k = (this.f_96543_ - this.f_97726_) / 2 + 3;
        int l = (this.f_96544_ - this.f_97727_) / 2 + 3;
        x = x + k + 10;
        y = y + l + 10;
        RenderSystem.setShader(GameRenderer::m_172838_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.RECIPE);
        matrixStack.m_280218_(this.RECIPE, x - 5, y - 5, 0, 0, 112, 62);
        this.renderItem(matrixStack, mouseX, mouseY, x, y, recipe, 0);
        this.renderItem(matrixStack, mouseX, mouseY, x, y += 18, recipe, 1);
        this.renderItem(matrixStack, mouseX, mouseY, x += 18, y, recipe, 3);
        this.renderItem(matrixStack, mouseX, mouseY, x -= 18, y += 18, recipe, 2);
        this.renderItem(matrixStack, mouseX, mouseY, x += 36, y -= 36, recipe, 4);
        this.renderItem(matrixStack, mouseX, mouseY, x, y += 18, recipe, 5);
        this.renderItem(matrixStack, mouseX, mouseY, x, y += 18, recipe, 6);
        this.renderItem(matrixStack, mouseX, mouseY, x + 46, y -= 18, recipe, 7);
        RenderSystem.enableDepthTest();
    }

    public void renderItem(GuiGraphics matrixStack, int mouseX, int mouseY, int x, int y, EnumSummoningRecipes recipe, int index) {
        ItemStack item = new ItemStack((ItemLike)recipe.getItem(index));
        matrixStack.m_280480_(item, x, y);
        if (this.isMouseOver(mouseX, mouseY, x, y)) {
            this.renderTooltip(matrixStack, mouseX, mouseY, item);
        }
    }

    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY, ItemStack item) {
        pGuiGraphics.renderTooltip(this.f_96547_, JRecipeBookGUI.m_280152_((Minecraft)this.getMinecraft(), (ItemStack)item), item.m_150921_(), item, pX, pY);
    }

    protected boolean isMouseOver(int mouseX, int mouseY, int spriteX, int spriteY) {
        if (mouseX >= spriteX && mouseX <= spriteX + 16 && mouseY >= spriteY) {
            return mouseY <= spriteY + 16;
        }
        return false;
    }

    protected void m_181908_() {
        super.m_181908_();
        this.nextButton.f_93623_ = this.pageNumber < 1;
        this.previousButton.f_93623_ = this.pageNumber > 0;
    }

    protected void m_280003_(@NotNull GuiGraphics matrixStack, int x, int y) {
    }
}

