/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.jitl.client.gui.overlay.helper.JDisplayInfo;
import net.jitl.client.gui.overlay.helper.JFrameType;
import net.jitl.client.gui.overlay.helper.JToast;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.core.helper.internal.ArgbColor;
import net.jitl.core.init.JITL;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class KnowledgeToast
implements JToast {
    private final EnumKnowledge knowledge;
    private boolean playedSound;
    private final boolean isLevel;
    private final ResourceLocation KNOWLEDGE_SPRITE = JITL.rl("textures/gui/knowledge/knowledge_sprites.png");

    public KnowledgeToast(EnumKnowledge knowledge, boolean isLevel) {
        this.knowledge = knowledge;
        this.isLevel = isLevel;
    }

    @Override
    @NotNull
    public Toast.Visibility m_7172_(GuiGraphics poseStack, ToastComponent toastComponent, long timeSinceLastVisible) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        JDisplayInfo displayinfo = this.isLevel ? this.knowledge.getLevelDisplay() : this.knowledge.getXPDisplay();
        poseStack.m_280218_(TEXTURE, 0, 0, 0, 0, this.m_7828_(), this.m_94899_());
        if (displayinfo != null) {
            int i;
            List list = toastComponent.m_94929_().f_91062_.m_92923_((FormattedText)displayinfo.getDescription(), 125);
            int n = i = displayinfo.getFrame() == JFrameType.LEVEL ? ArgbColor.from(ChatFormatting.DARK_PURPLE) : ArgbColor.from(ChatFormatting.BLACK);
            if (list.size() == 1) {
                poseStack.m_280614_(toastComponent.m_94929_().f_91062_, displayinfo.getFrame().getDisplayName(), 30, 18, i, false);
                poseStack.m_280649_(toastComponent.m_94929_().f_91062_, (FormattedCharSequence)list.get(0), 30, 7, ArgbColor.from(ChatFormatting.BLACK), false);
            } else if (timeSinceLastVisible < 1500L) {
                int k = Mth.m_14143_((float)(Mth.m_14036_((float)((float)(1500L - timeSinceLastVisible) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
                poseStack.m_280614_(toastComponent.m_94929_().f_91062_, displayinfo.getFrame().getDisplayName(), 30, 11, i | k, false);
            } else {
                int i1 = Mth.m_14143_((float)(Mth.m_14036_((float)((float)(timeSinceLastVisible - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
                int l = this.m_94899_() / 2 - list.size() * 9 / 2;
                for (FormattedCharSequence formattedcharsequence : list) {
                    poseStack.m_280649_(toastComponent.m_94929_().f_91062_, formattedcharsequence, 30, l, 0xFFFFFF | i1, false);
                    l += 9;
                }
            }
            if (!this.playedSound && timeSinceLastVisible > 0L) {
                this.playedSound = true;
                if (displayinfo.getFrame() == JFrameType.LEVEL) {
                    toastComponent.m_94929_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)JSounds.TOAST_SPECIAL.get()), (float)1.0f, (float)1.0f));
                }
                if (displayinfo.getFrame() == JFrameType.XP) {
                    toastComponent.m_94929_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)JSounds.TOAST.get()), (float)1.0f, (float)1.0f));
                }
            }
            float scale = 0.8f;
            double translate = 2.5;
            poseStack.m_280168_().m_85836_();
            poseStack.m_280168_().m_85841_(scale, scale, scale);
            poseStack.m_280168_().m_85837_(translate, translate, translate);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.KNOWLEDGE_SPRITE);
            poseStack.m_280218_(this.KNOWLEDGE_SPRITE, 1, 1, this.knowledge.getSpriteX(), this.knowledge.getSpriteY(), 32, 32);
            poseStack.m_280168_().m_85849_();
            return timeSinceLastVisible >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
        }
        return Toast.Visibility.HIDE;
    }
}

