/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.client.stats.ClientPlayerStats;
import net.jitl.common.capability.stats.PlayerStatsProvider;
import net.jitl.core.helper.internal.ArgbColor;
import net.jitl.core.helper.internal.EmptyContainer;
import net.jitl.core.init.JITL;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class PlayerStats
extends AbstractContainerScreen<EmptyContainer> {
    private PageButton nextButton;
    private PageButton previousButton;
    private final ResourceLocation KNOWLEDGE_SPRITE = JITL.rl("textures/gui/knowledge/knowledge_sprites.png");
    private final ResourceLocation BACKGROUND = JITL.rl("textures/gui/stats.png");
    public int pageNumber = 0;
    public Player player;

    public PlayerStats(Player player) {
        super((AbstractContainerMenu)new EmptyContainer(), player.m_150109_(), (Component)Component.m_237115_((String)"jitl.stats"));
        this.f_97726_ = 242;
        this.f_97727_ = 197;
        this.player = player;
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
        this.updateButtonVisibility();
    }

    protected void m_7856_() {
        super.m_7856_();
        int w = (this.f_96543_ - this.f_97726_) / 2;
        int h = (this.f_96544_ - this.f_97727_) / 2;
        int xPos = w + 95;
        int yPos = h + 177;
        this.nextButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(xPos + 32, yPos, true, button -> this.flipPage(true), true));
        this.previousButton = (PageButton)this.m_142416_((GuiEventListener)new PageButton(xPos, yPos, false, button -> this.flipPage(false), true));
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        this.nextButton.f_93624_ = true;
        this.previousButton.f_93624_ = true;
        this.nextButton.f_93623_ = this.pageNumber != 1;
        this.previousButton.f_93623_ = this.pageNumber != 0;
    }

    protected void flipPage(boolean forward) {
        this.pageNumber = forward ? ++this.pageNumber : --this.pageNumber;
        this.updateButtonVisibility();
    }

    protected void m_7286_(@NotNull GuiGraphics poseStack, float partialTick, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        poseStack.m_280168_().m_85836_();
        RenderSystem.setShader(GameRenderer::m_172838_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.BACKGROUND);
        poseStack.m_280218_(this.BACKGROUND, x, y, 0, 0, this.f_97726_, this.f_97727_);
        switch (this.pageNumber) {
            case 0: {
                this.page1(poseStack);
                break;
            }
            case 1: {
                this.page2(poseStack);
                break;
            }
        }
        poseStack.m_280168_().m_85849_();
        RenderSystem.enableDepthTest();
    }

    public void page1(GuiGraphics stack) {
        int height = 43;
        int x = 9;
        int h = 9;
        this.drawKnowledgeSprite(stack, x, h, EnumKnowledge.OVERWORLD, "Overworld");
        this.drawKnowledgeSprite(stack, 126, h, EnumKnowledge.NETHER, "The Nether");
        this.drawKnowledgeSprite(stack, x, h += height, EnumKnowledge.END, "End");
        this.drawKnowledgeSprite(stack, 126, h, EnumKnowledge.BOIL, "Boiling Point");
        this.drawKnowledgeSprite(stack, x, h += height, EnumKnowledge.FROZEN, "Frozen Lands");
        this.drawKnowledgeSprite(stack, 126, h, EnumKnowledge.EUCA, "Euca");
        this.drawKnowledgeSprite(stack, 126, h += height, EnumKnowledge.DEPTHS, "The Depths");
        this.drawKnowledgeSprite(stack, x, h, EnumKnowledge.CORBA, "Corba");
    }

    public void page2(GuiGraphics stack) {
        int height = 43;
        int x = 9;
        int h = 9;
        this.drawKnowledgeSprite(stack, x, h, EnumKnowledge.TERRANIA, "Terrania");
        this.drawKnowledgeSprite(stack, 126, h, EnumKnowledge.CLOUDIA, "Cloudia");
        this.drawKnowledgeSprite(stack, x, h += height, EnumKnowledge.SENTERIAN, "Senterain");
        this.drawSprite(stack, 126, h, 0, 74, "Sentacoins:");
    }

    public void drawSprite(GuiGraphics matrixStack, int x, int y, int spriteX, int spriteY, String s) {
        int k = (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        RenderSystem.setShader(GameRenderer::m_172838_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.BACKGROUND);
        matrixStack.m_280218_(this.BACKGROUND, k + x - 4, l + y - 4, 0, 216, 115, 40);
        RenderSystem.setShader(GameRenderer::m_172838_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.KNOWLEDGE_SPRITE);
        matrixStack.m_280218_(this.KNOWLEDGE_SPRITE, k + x, l + y, spriteX, spriteY, 32, 32);
        matrixStack.m_280056_(this.f_96547_, s, k + x + 35, l + y + 5, 0x404040, false);
        if (s.contains("Sentacoins")) {
            matrixStack.m_280488_(this.f_96547_, "" + ClientPlayerStats.getSentacoins(), k + x + 35, l + y + 15, ArgbColor.from(ChatFormatting.WHITE));
        }
        RenderSystem.enableDepthTest();
    }

    public void drawKnowledgeSprite(GuiGraphics matrixStack, int x, int y, EnumKnowledge type, String s) {
        this.drawSprite(matrixStack, x, y, type.getSpriteX(), type.getSpriteY(), s);
        int progressBarSize = 65;
        int k = (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        RenderSystem.setShader(GameRenderer::m_172838_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.KNOWLEDGE_SPRITE);
        if (this.player != null) {
            this.player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(knowledge -> {
                boolean completed = knowledge.isCompleted(type);
                float percents = knowledge.getXP(type) / knowledge.getLevelCapacity(knowledge.getLevel(type));
                int width = (int)(percents * (float)progressBarSize);
                int progressBarX = k + x + 35;
                int progressBarY = l + y + 19;
                matrixStack.m_280218_(this.KNOWLEDGE_SPRITE, progressBarX, progressBarY, 0, 5, progressBarSize, 5);
                matrixStack.m_280218_(this.KNOWLEDGE_SPRITE, progressBarX, progressBarY, 0, 0, width, 5);
                if (completed) {
                    matrixStack.m_280218_(this.KNOWLEDGE_SPRITE, k + x, l + y + 3, 130, 43, 32, 29);
                }
                int lvX = progressBarX + 29;
                int lvY = progressBarY - 1;
                int getLevelCount = knowledge.getLevel(type);
                String level = "" + getLevelCount;
                matrixStack.m_280056_(this.f_96547_, "" + getLevelCount, lvX - this.f_96547_.m_92895_(level) / 2 + 4, lvY, ArgbColor.from(ChatFormatting.WHITE), true);
            });
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        this.nextButton.f_93623_ = this.pageNumber < 1;
        this.previousButton.f_93623_ = this.pageNumber > 0;
    }

    protected void m_280003_(@NotNull GuiGraphics matrixStack, int x, int y) {
    }
}

