/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.jitl.common.entity.frozen.FrozenTrollEntity;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;

public class FrozenTrollModel<T extends Entity>
extends ListModel<T>
implements ArmedModel {
    private final ModelPart head;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart arm1;
    private final ModelPart arm2;
    private final ModelPart body;

    public FrozenTrollModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.leg1 = root.m_171324_("leg1");
        this.leg2 = root.m_171324_("leg2");
        this.arm1 = root.m_171324_("arm1");
        this.arm2 = root.m_171324_("arm2");
        this.body = root.m_171324_("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-5.0f, -7.625f, 0.25f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(32, 30).m_171488_(-3.0f, 1.375f, -3.25f, 6.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(32, 11).m_171488_(-2.0f, 6.375f, -2.75f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-4.0f, -6.625f, -3.75f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(3.0f, -7.625f, 0.25f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)9.625f, (float)0.75f));
        PartDefinition leg1 = partdefinition.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(16, 30).m_171480_().m_171488_(-2.0f, -0.5f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.25f, (float)17.5f, (float)2.0f));
        PartDefinition leg2 = partdefinition.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-2.0f, -0.5f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.25f, (float)17.5f, (float)2.0f));
        PartDefinition arm1 = partdefinition.m_171599_("arm1", CubeListBuilder.m_171558_().m_171514_(24, 16).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)9.0f, (float)1.0f));
        PartDefinition arm2 = partdefinition.m_171599_("arm2", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)9.0f, (float)1.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body_r1 = body.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, -4.0f, -2.0f, 8.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.5f, (float)2.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.head, (Object)this.body, (Object)this.arm1, (Object)this.arm2, (Object)this.leg1, (Object)this.leg2);
    }

    public void m_6973_(@NotNull T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.leg1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.leg2.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.arm1.f_104204_ = 0.0f;
        this.arm2.f_104204_ = 0.0f;
        this.arm2.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.arm1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        if (entityIn instanceof FrozenTrollEntity) {
            FrozenTrollEntity frozenTrollEntity = (FrozenTrollEntity)((Object)entityIn);
        }
    }

    public void m_6002_(HumanoidArm sideIn, PoseStack matrixStackIn) {
        this.getArm(sideIn).m_104299_(matrixStackIn);
    }

    private ModelPart getArm(HumanoidArm handSide_) {
        return handSide_ == HumanoidArm.LEFT ? this.arm1 : this.arm2;
    }
}

