/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.model;

import com.google.common.collect.ImmutableList;
import net.jitl.common.entity.frozen.Shiverwolf;
import net.minecraft.client.model.ColorableAgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShiverwolfModel<T extends Shiverwolf>
extends ColorableAgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart realHead;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private final ModelPart realTail;
    private final ModelPart upperBody;

    public ShiverwolfModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.realHead = this.head.m_171324_("real_head");
        this.body = root.m_171324_("body");
        this.upperBody = root.m_171324_("upper_body");
        this.rightHindLeg = root.m_171324_("right_hind_leg");
        this.leftHindLeg = root.m_171324_("left_hind_leg");
        this.rightFrontLeg = root.m_171324_("right_front_leg");
        this.leftFrontLeg = root.m_171324_("left_front_leg");
        this.tail = root.m_171324_("tail");
        this.realTail = this.tail.m_171324_("real_tail");
    }

    public static MeshDefinition createMeshDefinition(CubeDeformation cubeDeformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        float f = 13.5f;
        PartDefinition partdefinition1 = partdefinition.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)13.5f, (float)-7.0f));
        partdefinition1.m_171599_("real_head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, cubeDeformation).m_171514_(16, 14).m_171488_(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, cubeDeformation).m_171514_(16, 14).m_171488_(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, cubeDeformation).m_171514_(0, 10).m_171488_(-0.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, cubeDeformation), PartPose.f_171404_);
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(18, 14).m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, cubeDeformation), PartPose.m_171423_((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("upper_body", CubeListBuilder.m_171558_().m_171514_(21, 0).m_171488_(-3.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, cubeDeformation), PartPose.m_171423_((float)-1.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubeDeformation);
        partdefinition.m_171599_("right_hind_leg", cubelistbuilder, PartPose.m_171419_((float)-2.5f, (float)16.0f, (float)7.0f));
        partdefinition.m_171599_("left_hind_leg", cubelistbuilder, PartPose.m_171419_((float)0.5f, (float)16.0f, (float)7.0f));
        partdefinition.m_171599_("right_front_leg", cubelistbuilder, PartPose.m_171419_((float)-2.5f, (float)16.0f, (float)-4.0f));
        partdefinition.m_171599_("left_front_leg", cubelistbuilder, PartPose.m_171419_((float)0.5f, (float)16.0f, (float)-4.0f));
        PartDefinition partdefinition2 = partdefinition.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        partdefinition2.m_171599_("real_tail", CubeListBuilder.m_171558_().m_171514_(9, 18).m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubeDeformation), PartPose.f_171404_);
        return meshdefinition;
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.tail, (Object)this.upperBody);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.tail.f_104204_ = entity.m_21660_() ? 0.0f : Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        if (entity.m_21825_()) {
            this.upperBody.m_104227_(-1.0f, 16.0f, -3.0f);
            this.upperBody.f_104203_ = 1.2566371f;
            this.upperBody.f_104204_ = 0.0f;
            this.body.m_104227_(0.0f, 18.0f, 0.0f);
            this.body.f_104203_ = 0.7853982f;
            this.tail.m_104227_(-1.0f, 21.0f, 6.0f);
            this.rightHindLeg.m_104227_(-2.5f, 22.7f, 2.0f);
            this.rightHindLeg.f_104203_ = 4.712389f;
            this.leftHindLeg.m_104227_(0.5f, 22.7f, 2.0f);
            this.leftHindLeg.f_104203_ = 4.712389f;
            this.rightFrontLeg.f_104203_ = 5.811947f;
            this.rightFrontLeg.m_104227_(-2.49f, 17.0f, -4.0f);
            this.leftFrontLeg.f_104203_ = 5.811947f;
            this.leftFrontLeg.m_104227_(0.51f, 17.0f, -4.0f);
        } else {
            this.body.m_104227_(0.0f, 14.0f, 2.0f);
            this.body.f_104203_ = 1.5707964f;
            this.upperBody.m_104227_(-1.0f, 14.0f, -3.0f);
            this.upperBody.f_104203_ = this.body.f_104203_;
            this.tail.m_104227_(-1.0f, 12.0f, 8.0f);
            this.rightHindLeg.m_104227_(-2.5f, 16.0f, 7.0f);
            this.leftHindLeg.m_104227_(0.5f, 16.0f, 7.0f);
            this.rightFrontLeg.m_104227_(-2.5f, 16.0f, -4.0f);
            this.leftFrontLeg.m_104227_(0.5f, 16.0f, -4.0f);
            this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
        this.realHead.f_104205_ = ((Shiverwolf)((Object)entity)).getHeadRollAngle(partialTick) + ((Shiverwolf)((Object)entity)).getBodyRollAngle(partialTick, 0.0f);
        this.upperBody.f_104205_ = ((Shiverwolf)((Object)entity)).getBodyRollAngle(partialTick, -0.08f);
        this.body.f_104205_ = ((Shiverwolf)((Object)entity)).getBodyRollAngle(partialTick, -0.16f);
        this.realTail.f_104205_ = ((Shiverwolf)((Object)entity)).getBodyRollAngle(partialTick, -0.2f);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.tail.f_104203_ = ageInTicks;
    }
}

