/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.music;

import net.jitl.core.helper.JMusic;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jitl", value={Dist.CLIENT})
public class JMusicTicker {
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();
    private static SoundInstance currentTrack;
    private static JMusic shouldPlayTrack;
    private static int timeToNext;
    private static final RandomSource RANDOM;

    @SubscribeEvent
    public static void musicTick(TickEvent.ClientTickEvent musicEvent) {
        if (musicEvent.phase == TickEvent.Phase.START) {
            shouldPlayTrack = null;
        } else if (!MINECRAFT.m_91104_()) {
            if (currentTrack == null != (shouldPlayTrack == null)) {
                JMusicTicker.switchTracks();
            }
            if (currentTrack != null) {
                if (currentTrack.m_7904_() != shouldPlayTrack.getEvent().m_11660_()) {
                    JMusicTicker.switchTracks();
                }
                JMusicTicker.MINECRAFT.m_91397_().f_120180_ = 100;
                if (!MINECRAFT.m_91106_().m_120403_(currentTrack)) {
                    if (timeToNext <= 0) {
                        MINECRAFT.m_91106_().m_120367_(currentTrack);
                        timeToNext = Mth.m_216271_((RandomSource)RANDOM, (int)shouldPlayTrack.getMin(), (int)shouldPlayTrack.getMax());
                        MINECRAFT.m_91397_().m_120186_();
                    } else {
                        --timeToNext;
                    }
                }
            }
        }
    }

    public static void addTrack(JMusic track) {
        if (shouldPlayTrack == null || track.getMusicImportance() > shouldPlayTrack.getMusicImportance()) {
            shouldPlayTrack = track;
        }
    }

    private static void switchTracks() {
        MINECRAFT.m_91106_().m_120399_(currentTrack);
        if (shouldPlayTrack != null) {
            currentTrack = SimpleSoundInstance.m_119745_((SoundEvent)shouldPlayTrack.getEvent());
        } else {
            currentTrack = null;
            Music vanillaMusic = MINECRAFT.m_91107_();
            JMusicTicker.MINECRAFT.m_91397_().f_120180_ = Mth.m_216271_((RandomSource)RANDOM, (int)0, (int)(vanillaMusic.m_11636_() / 2));
        }
    }

    public static boolean isMusicPlaying(SoundEvent event) {
        return currentTrack != null && event.m_11660_() == currentTrack.m_7904_() && MINECRAFT.m_91106_().m_120403_(currentTrack);
    }

    static {
        RANDOM = RandomSource.m_216327_();
    }
}

