/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.jitl.client.JModelLayers;
import net.jitl.common.block.JChestBlock;
import net.jitl.common.block.entity.JChestBlockEntity;
import net.jitl.core.init.JITL;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class JChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    protected final ModelPart lid;
    protected final ModelPart bottom;
    protected final ModelPart lock;
    protected final ModelPart doubleLeftLid;
    protected final ModelPart doubleLeftBottom;
    protected final ModelPart doubleLeftLock;
    protected final ModelPart doubleRightLid;
    protected final ModelPart doubleRightBottom;
    protected final ModelPart doubleRightLock;

    public JChestRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.m_173582_(JModelLayers.JCHEST);
        this.bottom = modelpart.m_171324_("bottom");
        this.lid = modelpart.m_171324_("lid");
        this.lock = modelpart.m_171324_("lock");
        ModelPart modelpart1 = context.m_173582_(JModelLayers.JDOUBLE_CHEST_LEFT);
        this.doubleLeftBottom = modelpart1.m_171324_("bottom");
        this.doubleLeftLid = modelpart1.m_171324_("lid");
        this.doubleLeftLock = modelpart1.m_171324_("lock");
        ModelPart modelpart2 = context.m_173582_(JModelLayers.JDOUBLE_CHEST_RIGHT);
        this.doubleRightBottom = modelpart2.m_171324_("bottom");
        this.doubleRightLid = modelpart2.m_171324_("lid");
        this.doubleRightLock = modelpart2.m_171324_("lock");
    }

    public static LayerDefinition createSingleBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partdefinition.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.m_171599_("lock", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyRightLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partdefinition.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.m_171599_("lock", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(15.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyLeftLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partdefinition.m_171599_("lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.m_171599_("lock", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_6922_(T blockEntity, float partialTick, PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = blockEntity.m_58904_();
        boolean viable = level != null;
        BlockState blockstate = viable ? blockEntity.m_58900_() : (BlockState)blockEntity.m_58900_().m_60734_().m_49966_().m_61124_((Property)JChestBlock.FACING, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.m_61138_(JChestBlock.TYPE) ? (ChestType)blockstate.m_61143_(JChestBlock.TYPE) : ChestType.SINGLE;
        Block block = blockstate.m_60734_();
        JChestBlock chest = (JChestBlock)block;
        boolean isDouble = chesttype != ChestType.SINGLE;
        poseStack.m_85836_();
        float f = ((Direction)blockstate.m_61143_((Property)JChestBlock.FACING)).m_122435_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-f));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        DoubleBlockCombiner.NeighborCombineResult<? extends JChestBlockEntity> res = viable ? chest.m_5641_(blockstate, level, blockEntity.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
        float f1 = ((Float2FloatFunction)res.m_5649_(JChestBlock.opennessCombiner((LidBlockEntity)blockEntity))).get(partialTick);
        f1 = 1.0f - f1;
        f1 = 1.0f - f1 * f1 * f1;
        int i = ((Int2IntFunction)res.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(packedLight);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)JITL.rl("textures/models/block/chest/" + this.getNameFromBlock(chest) + ".png")));
        if (isDouble) {
            if (chesttype == ChestType.LEFT) {
                vertexconsumer = bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)JITL.rl("textures/models/block/chest/" + this.getNameFromBlock(chest) + "_left.png")));
                this.render(poseStack, vertexconsumer, this.doubleLeftLid, this.doubleLeftLock, this.doubleLeftBottom, f1, i, packedOverlay);
            } else {
                vertexconsumer = bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)JITL.rl("textures/models/block/chest/" + this.getNameFromBlock(chest) + "_right.png")));
                this.render(poseStack, vertexconsumer, this.doubleRightLid, this.doubleRightLock, this.doubleRightBottom, f1, i, packedOverlay);
            }
        } else {
            this.render(poseStack, vertexconsumer, this.lid, this.lock, this.bottom, f1, i, packedOverlay);
        }
        poseStack.m_85849_();
        if (((Boolean)blockstate.m_61143_((Property)JChestBlock.IS_LOCKED)).booleanValue()) {
            if (isDouble) {
                if (chesttype == ChestType.LEFT) {
                    this.renderItem(new ItemStack((ItemLike)JItems.PADLOCK.get()), new double[]{0.0, 0.2, 0.945}, poseStack, bufferSource, packedOverlay, packedLight, blockstate);
                } else {
                    this.renderItem(new ItemStack((ItemLike)JItems.PADLOCK.get()), new double[]{1.0, 0.2, 0.945}, poseStack, bufferSource, packedOverlay, packedLight, blockstate);
                }
            } else {
                this.renderItem(new ItemStack((ItemLike)JItems.PADLOCK.get()), new double[]{0.5, 0.2, 0.945}, poseStack, bufferSource, packedOverlay, packedLight, blockstate);
            }
        }
    }

    private void renderItem(ItemStack stack, double[] translation, PoseStack matrixStack, MultiBufferSource buffer, int combinedOverlay, int lightLevel, BlockState state) {
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        matrixStack.m_85836_();
        float f = ((Direction)state.m_61143_((Property)JChestBlock.FACING)).m_122435_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-f));
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        matrixStack.m_85837_(translation[0], translation[1], translation[2]);
        float scale = 1.0f;
        matrixStack.m_85841_(scale, scale, scale + 0.15f);
        BakedModel model = renderer.m_174264_(stack, null, null, 0);
        renderer.m_115143_(stack, ItemDisplayContext.GROUND, true, matrixStack, buffer, lightLevel, combinedOverlay, model);
        matrixStack.m_85849_();
    }

    public String getNameFromBlock(JChestBlock chest) {
        String name = "";
        if (chest == JBlocks.JOURNEY_CHEST.get()) {
            name = "journey_chest";
        }
        if (chest == JBlocks.EUCA_CHEST.get()) {
            name = "euca_chest";
        }
        if (chest == JBlocks.FROZEN_CHEST.get()) {
            name = "frozen_chest";
        }
        if (chest == JBlocks.BOIL_CHEST.get()) {
            name = "boiling_chest";
        }
        if (chest == JBlocks.NETHER_CHEST.get()) {
            name = "nether_chest";
        }
        if (chest == JBlocks.DEPTHS_CHEST.get()) {
            name = "depths_chest";
        }
        if (chest == JBlocks.CORBA_CHEST.get()) {
            name = "corba_chest";
        }
        if (chest == JBlocks.TERRANIAN_CHEST.get()) {
            name = "terranian_chest";
        }
        if (chest == JBlocks.CLOUDIA_CHEST.get()) {
            name = "cloudia_chest";
        }
        if (chest == JBlocks.SENTERIAN_CHEST.get()) {
            name = "senterian_chest";
        }
        return name;
    }

    private void render(PoseStack poseStack, VertexConsumer consumer, ModelPart lidPart, ModelPart lockPart, ModelPart bottomPart, float lidAngle, int packedLight, int packedOverlay) {
        lockPart.f_104203_ = lidPart.f_104203_ = -(lidAngle * 1.5707964f);
        lidPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        lockPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        bottomPart.m_104301_(poseStack, consumer, packedLight, packedOverlay);
    }
}

