/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.entity.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.jitl.core.helper.RandHelper;
import net.jitl.core.init.JITL;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderAnimated2D<T extends Entity>
extends EntityRenderer<T> {
    public String[] textures;
    public int animationSpeed;
    private final boolean fullBright = true;

    public RenderAnimated2D(EntityRendererProvider.Context context, int animationSpeed, String ... textures) {
        super(context);
        this.textures = textures;
        this.animationSpeed = animationSpeed;
    }

    public void m_7392_(@NotNull T entityIn, float entityYaw, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        if (((Entity)entityIn).f_19797_ >= 2 || !(this.f_114476_.f_114358_.m_90592_().m_20280_(entityIn) < 12.25)) {
            this.render(entityIn, matrixStackIn, bufferIn, packedLightIn);
        }
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected int m_6086_(@NotNull T entity, @NotNull BlockPos pos) {
        Objects.requireNonNull(this);
        return 15;
    }

    private void render(@NotNull T entityIn, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        float scale = 0.5f;
        matrixStackIn.m_85841_(scale, scale, scale);
        matrixStackIn.m_252781_(this.f_114476_.m_253208_());
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        matrixStackIn.m_85837_(0.0, 0.5, 0.0);
        float scale1 = 1.0f;
        matrixStackIn.m_85841_(scale1, scale1, scale1);
        PoseStack.Pose lastMatrix = matrixStackIn.m_85850_();
        Matrix4f pose = lastMatrix.m_252922_();
        Matrix3f normal = lastMatrix.m_252943_();
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)this.m_5478_(entityIn)));
        RenderAnimated2D.vertex(ivertexbuilder, pose, normal, packedLightIn, 0.0f, 0.0f, 0, 1);
        RenderAnimated2D.vertex(ivertexbuilder, pose, normal, packedLightIn, 1.0f, 0.0f, 1, 1);
        RenderAnimated2D.vertex(ivertexbuilder, pose, normal, packedLightIn, 1.0f, 1.0f, 1, 0);
        RenderAnimated2D.vertex(ivertexbuilder, pose, normal, packedLightIn, 0.0f, 1.0f, 0, 0);
        matrixStackIn.m_85849_();
    }

    private static void vertex(VertexConsumer builder, Matrix4f pose, Matrix3f normal, int lightmapUV, float x, float y, int u, int v) {
        builder.m_252986_(pose, x - 0.5f, y - 0.5f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)u, (float)v).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmapUV).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    @NotNull
    public ResourceLocation m_5478_(T t) {
        RandomSource r = RandomSource.m_216327_();
        if (((Entity)t).f_19797_ % this.animationSpeed == 0) {
            String name = RandHelper.chooseEqual(r, this.textures);
            return JITL.rl("textures/entity/" + name + ".png");
        }
        if (((Entity)t).f_19797_ % (this.animationSpeed / 2) == 0) {
            String name = RandHelper.chooseEqual(r, this.textures);
            return JITL.rl("textures/entity/" + name + ".png");
        }
        return JITL.rl("textures/entity/" + this.textures[0] + ".png");
    }
}

