/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CaveVineParticle
extends TextureSheetParticle {
    private final float rotSpeed;
    private final SpriteSet sprites;

    private CaveVineParticle(ClientLevel worldIn, double x, double y, double z, SpriteSet spriteWithAge) {
        super(worldIn, x, y, z);
        this.sprites = spriteWithAge;
        this.f_107663_ *= 0.67499995f;
        int i = (int)(32.0 / (Math.random() * 0.8 + 0.2));
        this.f_107225_ = (int)Math.max((float)i * 0.9f, 1.0f);
        this.m_108339_(spriteWithAge);
        this.rotSpeed = ((float)Math.random() - 0.5f) * 0.1f;
        this.f_107231_ = (float)Math.random() * ((float)Math.PI * 2);
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public float m_5902_(float scaleFactor) {
        return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + scaleFactor) / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
    }

    public int m_6355_(float partialTick) {
        float f = ((float)this.f_107224_ + partialTick) / (float)this.f_107225_;
        f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        int i = super.m_6355_(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_108339_(this.sprites);
            this.f_107204_ = this.f_107231_;
            this.f_107231_ += (float)Math.PI * this.rotSpeed * 2.0f;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107216_ -= (double)0.003f;
            this.f_107216_ = Math.max(this.f_107216_, (double)-0.14f);
            if (this.f_107218_) {
                this.f_107231_ = 0.0f;
                this.f_107204_ = 0.0f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Factory(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(@NotNull SimpleParticleType typeIn, @NotNull ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new CaveVineParticle(worldIn, x, y, z, this.sprites);
        }
    }
}

