/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class HellstoneParticle
extends TextureSheetParticle {
    private final double xStart;
    private final double yStart;
    private final double zStart;

    protected HellstoneParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
        super(pLevel, pX, pY, pZ);
        this.f_107215_ = pXSpeed;
        this.f_107216_ = pYSpeed;
        this.f_107217_ = pZSpeed;
        this.f_107212_ = pX;
        this.f_107213_ = pY;
        this.f_107214_ = pZ;
        this.xStart = this.f_107212_;
        this.yStart = this.f_107213_;
        this.zStart = this.f_107214_;
        this.f_107663_ = 0.1f * (this.f_107223_.m_188501_() * 0.2f + 0.5f);
        this.f_107227_ = 1.0f;
        this.f_107228_ = 0.6f * pLevel.f_46441_.m_188501_();
        this.f_107229_ = 6.0f * pLevel.f_46441_.m_188501_();
        this.m_6569_(1.75f);
        this.f_107225_ = (int)(Math.random() * 10.0) + 40;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_6257_(double pX, double pY, double pZ) {
        this.m_107259_(this.m_107277_().m_82386_(pX, pY, pZ));
        this.m_107275_();
    }

    public float m_5902_(float pScaleFactor) {
        float f = ((float)this.f_107224_ + pScaleFactor) / (float)this.f_107225_;
        f = 1.0f - f;
        f *= f;
        f = 1.0f - f;
        return this.f_107663_ * f;
    }

    public int m_6355_(float pPartialTick) {
        int i = super.m_6355_(pPartialTick);
        float f = (float)this.f_107224_ / (float)this.f_107225_;
        f *= f;
        f *= f;
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((k += (int)(f * 15.0f * 16.0f)) > 240) {
            k = 240;
        }
        return j | k << 16;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            float f = (float)this.f_107224_ / (float)this.f_107225_;
            float f1 = -f + f * f * 2.0f;
            float f2 = 1.0f - f1;
            this.f_107212_ = this.xStart + this.f_107215_ * (double)f2;
            this.f_107213_ = this.yStart + this.f_107216_ * (double)f2 + (double)(1.0f - f);
            this.f_107214_ = this.zStart + this.f_107217_ * (double)f2;
            this.m_107264_(this.f_107212_, this.f_107213_, this.f_107214_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Factory(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(@NotNull SimpleParticleType typeIn, @NotNull ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            HellstoneParticle part = new HellstoneParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            part.m_108335_(this.sprite);
            return part;
        }
    }
}

