/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.vehicle;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.jitl.client.JModelLayers;
import net.jitl.client.model.JBoatModel;
import net.jitl.common.entity.base.JBoat;
import net.jitl.core.init.JITL;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class JBoatRenderer
extends EntityRenderer<JBoat> {
    private final Map<JBoat.Type, Pair<ResourceLocation, JBoatModel>> boatResources;

    public JBoatRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.8f;
        this.boatResources = (Map)Stream.of(JBoat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, JBoatType -> Pair.of((Object)JITL.rl("textures/entity/boat/" + JBoatType.getName() + ".png"), (Object)((Object)new JBoatModel(context.m_174023_(JModelLayers.createBoatModelName(JBoatType)))))));
    }

    public void render(JBoat entity, float entityYaw, float partialTicks_, PoseStack matrixStack, @NotNull MultiBufferSource buffer, int packedLight) {
        float f2;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.375, 0.0);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        float f = (float)entity.m_38385_() - partialTicks_;
        float f1 = entity.m_38384_() - partialTicks_;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)entity.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = entity.m_38352_(partialTicks_)), (float)0.0f)) {
            matrixStack.m_252781_(new Quaternionf().setAngleAxis(entity.m_38352_(partialTicks_) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, JBoatModel> pair = this.getModelWithLocation(entity);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        JBoatModel JBoatmodel = (JBoatModel)((Object)pair.getSecond());
        matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        JBoatmodel.setupAnim(entity, partialTicks_, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = buffer.m_6299_(JBoatmodel.m_103119_(resourcelocation));
        JBoatmodel.m_7695_(matrixStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entity.m_5842_()) {
            VertexConsumer v = buffer.m_6299_(RenderType.m_110478_());
            JBoatmodel.waterPatch().m_104301_(matrixStack, v, packedLight, OverlayTexture.f_118083_);
        }
        matrixStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks_, matrixStack, buffer, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull JBoat entity) {
        return (ResourceLocation)this.getModelWithLocation(entity).getFirst();
    }

    public Pair<ResourceLocation, JBoatModel> getModelWithLocation(JBoat JBoat2) {
        return this.boatResources.get((Object)JBoat2.getJBoatType());
    }
}

