/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.world;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.jitl.client.render.world.JCloudRenderer;
import net.jitl.core.init.JITL;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class CloudiaRenderInfo
extends DimensionSpecialEffects {
    private static final ResourceLocation SUN_LOCATION = JITL.rl("textures/environment/cloudia_sun.png");
    private static final ResourceLocation CLOUDIA_SKY_LOCATION = JITL.rl("textures/environment/cloudia_sky.png");

    public CloudiaRenderInfo() {
        super(63.0f, true, DimensionSpecialEffects.SkyType.NONE, false, false);
    }

    public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f projectionMatrix) {
        new JCloudRenderer(JITL.rl("textures/environment/cloudia_clouds.png")).render(level, ticks, partialTick, poseStack, Minecraft.m_91087_(), camX, camY, camZ, projectionMatrix);
        return true;
    }

    @NotNull
    public Vec3 m_5927_(Vec3 vector3d, float float_) {
        float color = 1.0f;
        return vector3d.m_82542_((double)(float_ * color), (double)(float_ * color), (double)(float_ * color));
    }

    public boolean m_5781_(int i, int i2) {
        return false;
    }

    public boolean renderSky(@NotNull ClientLevel level, int ticks, float partialTick, @NotNull PoseStack poseStack, @NotNull Camera camera, @NotNull Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        Minecraft mc = Minecraft.m_91087_();
        setupFog.run();
        FogType fogtype = camera.m_167685_();
        if (fogtype != FogType.POWDER_SNOW && fogtype != FogType.LAVA && !CloudiaRenderInfo.doesMobEffectBlockSky(camera)) {
            Vec3 vec3 = level.m_171660_(mc.f_91063_.m_109153_().m_90583_(), partialTick);
            float f = (float)vec3.f_82479_;
            float f1 = (float)vec3.f_82480_;
            float f2 = (float)vec3.f_82481_;
            FogRenderer.m_109036_();
            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)f, (float)f1, (float)f2, (float)1.0f);
            VertexBuffer.m_85931_();
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            float f3 = Mth.m_14031_((float)level.m_46490_(partialTick)) < 0.0f ? 180.0f : 0.0f;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(f3));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            poseStack.m_85849_();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            poseStack.m_85836_();
            this.renderSkyTexture(poseStack);
            Matrix4f matrix4f1 = poseStack.m_85850_().m_252922_();
            float f12 = 14.0f;
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(level.m_46942_(partialTick) * 360.0f));
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SUN_LOCATION);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_252986_(matrix4f1, -f12, 100.0f, -f12).m_7421_(0.0f, 0.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f1, f12, 100.0f, -f12).m_7421_(1.0f, 0.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f1, f12, 100.0f, f12).m_7421_(1.0f, 1.0f).m_5752_();
            bufferbuilder.m_252986_(matrix4f1, -f12, 100.0f, f12).m_7421_(0.0f, 1.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.m_85849_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)true);
        }
        return false;
    }

    @Nullable
    public float[] m_7518_(float ff, float ff1) {
        return null;
    }

    private void renderSkyTexture(PoseStack pPoseStack) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CLOUDIA_SKY_LOCATION);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        for (int i = 0; i < 6; ++i) {
            pPoseStack.m_85836_();
            if (i == 1) {
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            }
            if (i == 2) {
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            }
            if (i == 3) {
                pPoseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            }
            if (i == 4) {
                pPoseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
            }
            if (i == 5) {
                pPoseStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
            }
            Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            bufferbuilder.m_252986_(matrix4f, -100.0f, -100.0f, -100.0f).m_7421_(0.0f, 0.0f).m_6122_(40, 40, 40, 255).m_5752_();
            bufferbuilder.m_252986_(matrix4f, -100.0f, -100.0f, 100.0f).m_7421_(0.0f, 16.0f).m_6122_(40, 40, 40, 255).m_5752_();
            bufferbuilder.m_252986_(matrix4f, 100.0f, -100.0f, 100.0f).m_7421_(16.0f, 16.0f).m_6122_(40, 40, 40, 255).m_5752_();
            bufferbuilder.m_252986_(matrix4f, 100.0f, -100.0f, -100.0f).m_7421_(16.0f, 0.0f).m_6122_(40, 40, 40, 255).m_5752_();
            tesselator.m_85914_();
            pPoseStack.m_85849_();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public static boolean doesMobEffectBlockSky(Camera camera) {
        Entity entity = camera.m_90592_();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)entity;
        return livingentity.m_21023_(MobEffects.f_19610_) || livingentity.m_21023_(MobEffects.f_216964_);
    }
}

