/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.render.world;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class JCloudRenderer {
    private CloudStatus prevCloudsType;
    private Vec3 prevCloudColor = Vec3.f_82478_;
    private VertexBuffer cloudBuffer;
    private int prevCloudX = Integer.MIN_VALUE;
    private int prevCloudY = Integer.MIN_VALUE;
    private int prevCloudZ = Integer.MIN_VALUE;
    private boolean generateClouds = true;
    private final ResourceLocation CLOUDS_LOCATION;

    public JCloudRenderer(ResourceLocation texture) {
        this.CLOUDS_LOCATION = texture;
    }

    public void render(ClientLevel level, int ticks, float partialTicks, PoseStack matrixStackIn, Minecraft minecraft, double viewEntityX, double viewEntityY, double viewEntityZ, Matrix4f projectionMatrix) {
        float f = level.m_104583_().m_108871_();
        if (!Float.isNaN(f)) {
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.depthMask((boolean)true);
            double d1 = ((float)ticks + partialTicks) * 0.3f;
            double d2 = (viewEntityX + d1) / 12.0;
            double d3 = f - (float)viewEntityY + 0.33f;
            double d4 = viewEntityZ / 12.0 + (double)0.33f;
            d2 -= (double)(Mth.m_14107_((double)(d2 / 2048.0)) * 2048);
            d4 -= (double)(Mth.m_14107_((double)(d4 / 2048.0)) * 2048);
            float f3 = (float)(d2 - (double)Mth.m_14107_((double)d2));
            float f4 = (float)(d3 / 4.0 - (double)Mth.m_14107_((double)(d3 / 4.0))) * 4.0f;
            float f5 = (float)(d4 - (double)Mth.m_14107_((double)d4));
            Vec3 vector3d = level.m_104808_(partialTicks);
            int i = (int)Math.floor(d2);
            int j = (int)Math.floor(d3 / 4.0);
            int k = (int)Math.floor(d4);
            if (i != this.prevCloudX || j != this.prevCloudY || k != this.prevCloudZ || minecraft.f_91066_.m_92174_() != this.prevCloudsType || this.prevCloudColor.m_82557_(vector3d) > 2.0E-4) {
                this.prevCloudX = i;
                this.prevCloudY = j;
                this.prevCloudZ = k;
                this.prevCloudColor = vector3d;
                this.prevCloudsType = minecraft.f_91066_.m_92174_();
                this.generateClouds = true;
            }
            if (this.generateClouds) {
                this.generateClouds = false;
                BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
                if (this.cloudBuffer != null) {
                    this.cloudBuffer.close();
                }
                this.cloudBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
                BufferBuilder.RenderedBuffer buffer = this.buildClouds(bufferbuilder, d2, d3, d4, vector3d);
                this.cloudBuffer.m_85921_();
                this.cloudBuffer.m_231221_(buffer);
            }
            RenderSystem.setShader(GameRenderer::m_172838_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.CLOUDS_LOCATION);
            FogRenderer.m_109036_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(12.0f, 1.0f, 12.0f);
            matrixStackIn.m_252880_(-f3, f4, -f5);
            if (this.cloudBuffer != null) {
                int i1;
                for (int l = i1 = this.prevCloudsType == CloudStatus.FANCY ? 0 : 1; l < 2; ++l) {
                    if (l == 0) {
                        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    } else {
                        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    }
                    ShaderInstance shaderinstance = RenderSystem.getShader();
                    assert (shaderinstance != null);
                    this.cloudBuffer.m_253207_(matrixStackIn.m_85850_().m_252922_(), projectionMatrix, shaderinstance);
                }
                VertexBuffer.m_85931_();
                DefaultVertexFormat.f_85822_.m_86024_();
            }
            matrixStackIn.m_85849_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
        }
    }

    private BufferBuilder.RenderedBuffer buildClouds(BufferBuilder bufferIn, double cloudsX, double cloudsY, double cloudsZ, Vec3 cloudsColor) {
        float f3 = (float)Mth.m_14107_((double)cloudsX) * 0.00390625f;
        float f4 = (float)Mth.m_14107_((double)cloudsZ) * 0.00390625f;
        float f5 = (float)cloudsColor.f_82479_;
        float f6 = (float)cloudsColor.f_82480_;
        float f7 = (float)cloudsColor.f_82481_;
        float f8 = f5 * 0.9f;
        float f9 = f6 * 0.9f;
        float f10 = f7 * 0.9f;
        float f11 = f5 * 0.7f;
        float f12 = f6 * 0.7f;
        float f13 = f7 * 0.7f;
        float f14 = f5 * 0.8f;
        float f15 = f6 * 0.8f;
        float f16 = f7 * 0.8f;
        RenderSystem.setShader(GameRenderer::m_172838_);
        bufferIn.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
        float f17 = (float)Math.floor(cloudsY / 4.0) * 4.0f;
        if (this.prevCloudsType == CloudStatus.FANCY) {
            for (int k = -3; k <= 4; ++k) {
                for (int l = -3; l <= 4; ++l) {
                    float f18 = k * 8;
                    float f19 = l * 8;
                    if (f17 > -5.0f) {
                        bufferIn.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        bufferIn.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        bufferIn.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        bufferIn.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f11, f12, f13, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    }
                    if (f17 <= 5.0f) {
                        bufferIn.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 8.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        bufferIn.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 8.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        bufferIn.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        bufferIn.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f - 9.765625E-4f), (double)(f19 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    }
                    if (k > -1) {
                        for (int i1 = 0; i1 < 8; ++i1) {
                            bufferIn.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            bufferIn.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            bufferIn.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            bufferIn.m_5483_((double)(f18 + (float)i1 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)i1 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                        }
                    }
                    if (k <= 1) {
                        for (int j2 = 0; j2 < 8; ++j2) {
                            bufferIn.m_5483_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 0.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            bufferIn.m_5483_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 4.0f), (double)(f19 + 8.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 8.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            bufferIn.m_5483_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 4.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            bufferIn.m_5483_((double)(f18 + (float)j2 + 1.0f - 9.765625E-4f), (double)(f17 + 0.0f), (double)(f19 + 0.0f)).m_7421_((f18 + (float)j2 + 0.5f) * 0.00390625f + f3, (f19 + 0.0f) * 0.00390625f + f4).m_85950_(f8, f9, f10, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                        }
                    }
                    if (l > -1) {
                        for (int k2 = 0; k2 < 8; ++k2) {
                            bufferIn.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            bufferIn.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            bufferIn.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            bufferIn.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + (float)k2 + 0.0f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)k2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                        }
                    }
                    if (l > 1) continue;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        bufferIn.m_5483_((double)(f18 + 0.0f), (double)(f17 + 4.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        bufferIn.m_5483_((double)(f18 + 8.0f), (double)(f17 + 4.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        bufferIn.m_5483_((double)(f18 + 8.0f), (double)(f17 + 0.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).m_7421_((f18 + 8.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        bufferIn.m_5483_((double)(f18 + 0.0f), (double)(f17 + 0.0f), (double)(f19 + (float)l2 + 1.0f - 9.765625E-4f)).m_7421_((f18 + 0.0f) * 0.00390625f + f3, (f19 + (float)l2 + 0.5f) * 0.00390625f + f4).m_85950_(f14, f15, f16, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                    }
                }
            }
        } else {
            for (int l1 = -32; l1 < 32; l1 += 32) {
                for (int i2 = -32; i2 < 32; i2 += 32) {
                    bufferIn.m_5483_((double)l1, (double)f17, (double)(i2 + 32)).m_7421_((float)l1 * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    bufferIn.m_5483_((double)(l1 + 32), (double)f17, (double)(i2 + 32)).m_7421_((float)(l1 + 32) * 0.00390625f + f3, (float)(i2 + 32) * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    bufferIn.m_5483_((double)(l1 + 32), (double)f17, (double)i2).m_7421_((float)(l1 + 32) * 0.00390625f + f3, (float)i2 * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    bufferIn.m_5483_((double)l1, (double)f17, (double)i2).m_7421_((float)l1 * 0.00390625f + f3, (float)i2 * 0.00390625f + f4).m_85950_(f5, f6, f7, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                }
            }
        }
        return bufferIn.m_231175_();
    }
}

