/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.client.stats;

import java.util.function.Supplier;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.client.stats.ClientPlayerStats;
import net.jitl.common.capability.stats.PlayerStats;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketPlayerStats {
    private boolean hasBlizzard;
    private int sentacoins;
    private float knowledgeXP;
    private int level;
    private EnumKnowledge knowledge;

    public PacketPlayerStats(FriendlyByteBuf buf) {
        this.hasBlizzard = buf.readBoolean();
        this.sentacoins = buf.readInt();
        this.knowledgeXP = buf.readFloat();
        this.level = buf.readInt();
        this.knowledge = (EnumKnowledge)buf.m_130066_(EnumKnowledge.class);
    }

    public PacketPlayerStats(EnumKnowledge knowledge, PlayerStats stats) {
        if (stats == null || knowledge == null) {
            return;
        }
        this.hasBlizzard = stats.hasBlizzard();
        this.sentacoins = stats.getSentacoins();
        this.knowledgeXP = stats.getXP(knowledge);
        this.level = stats.getLevel(knowledge);
        this.knowledge = knowledge;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.hasBlizzard);
        buf.writeInt(this.sentacoins);
        buf.writeFloat(this.knowledgeXP);
        buf.writeInt(this.level);
        buf.m_130068_((Enum)this.knowledge);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            ClientPlayerStats.setHasBlizzard(this.hasBlizzard);
            ClientPlayerStats.setSentacoins(this.sentacoins);
            ClientPlayerStats.setClientKnowledgeLevel(this.knowledge, this.level);
            ClientPlayerStats.setClientKnowledgeXP(this.knowledge, this.knowledgeXP);
            ctx.get().setPacketHandled(true);
        }
    }
}

