/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CrystallizedDripstoneBlock
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.f_155997_;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.f_155998_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public CrystallizedDripstoneBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TIP_DIRECTION, (Comparable)Direction.UP)).m_61124_(THICKNESS, (Comparable)DripstoneThickness.TIP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_154157_) {
        p_154157_.m_61104_(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public boolean m_7898_(BlockState s, @NotNull LevelReader l, @NotNull BlockPos p) {
        return CrystallizedDripstoneBlock.isValidPointedDripstonePlacement(l, p, (Direction)s.m_61143_((Property)TIP_DIRECTION));
    }

    @NotNull
    public BlockState m_7417_(BlockState s, @NotNull Direction d, @NotNull BlockState s2, @NotNull LevelAccessor level, @NotNull BlockPos pos1, @NotNull BlockPos pos2) {
        if (((Boolean)s.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos1, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (d != Direction.UP && d != Direction.DOWN) {
            return s;
        }
        Direction direction = (Direction)s.m_61143_((Property)TIP_DIRECTION);
        if (direction == Direction.DOWN && level.m_183326_().m_183582_(pos1, (Object)this)) {
            return s;
        }
        if (d == direction.m_122424_() && !this.m_7898_(s, (LevelReader)level, pos1)) {
            if (direction == Direction.DOWN) {
                level.m_186460_(pos1, (Block)this, 2);
            } else {
                level.m_186460_(pos1, (Block)this, 1);
            }
            return s;
        }
        boolean flag = s.m_61143_(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = CrystallizedDripstoneBlock.calculateDripstoneThickness((LevelReader)level, pos1, direction, flag);
        return (BlockState)s.m_61124_(THICKNESS, (Comparable)dripstonethickness);
    }

    public void m_5581_(Level l, @NotNull BlockState s, @NotNull BlockHitResult b, @NotNull Projectile p) {
        if (!l.f_46443_) {
            BlockPos blockpos = b.m_82425_();
            if (!l.f_46443_ && p.m_142265_(l, blockpos) && p instanceof ThrownTrident && p.m_20184_().m_82553_() > 0.6) {
                l.m_46961_(blockpos, true);
            }
        }
    }

    public void m_142072_(@NotNull Level l, BlockState d, @NotNull BlockPos p, @NotNull Entity e, float f) {
        if (d.m_61143_((Property)TIP_DIRECTION) == Direction.UP && d.m_61143_(THICKNESS) == DripstoneThickness.TIP) {
            e.m_142535_(f + 2.0f, 2.0f, l.m_269111_().m_269571_());
        } else {
            super.m_142072_(l, d, p, e, f);
        }
    }

    public void m_213897_(@NotNull BlockState s, @NotNull ServerLevel l, @NotNull BlockPos p, @NotNull RandomSource r) {
        if (CrystallizedDripstoneBlock.isStalagmite(s) && !this.m_7898_(s, (LevelReader)l, p)) {
            l.m_46961_(p, true);
        } else {
            CrystallizedDripstoneBlock.spawnFallingStalactite(s, l, p);
        }
    }

    public void m_213898_(@NotNull BlockState s, @NotNull ServerLevel l, @NotNull BlockPos p, RandomSource r) {
        if (r.m_188501_() < 0.011377778f && CrystallizedDripstoneBlock.isStalactiteStartPos(s, (LevelReader)l, p)) {
            CrystallizedDripstoneBlock.growStalactiteOrStalagmiteIfPossible(s, l, p, r);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_154040_) {
        Direction direction;
        BlockPos blockpos;
        Level levelaccessor = p_154040_.m_43725_();
        Direction direction1 = CrystallizedDripstoneBlock.calculateTipDirection((LevelReader)levelaccessor, blockpos = p_154040_.m_8083_(), direction = p_154040_.m_151260_().m_122424_());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !p_154040_.m_7078_();
        DripstoneThickness dripstonethickness = CrystallizedDripstoneBlock.calculateDripstoneThickness((LevelReader)levelaccessor, blockpos, direction1, flag);
        return dripstonethickness == null ? null : (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TIP_DIRECTION, (Comparable)direction1)).m_61124_(THICKNESS, (Comparable)dripstonethickness)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_));
    }

    @NotNull
    public FluidState m_5888_(BlockState p_154235_) {
        return (Boolean)p_154235_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_154235_);
    }

    @NotNull
    public VoxelShape m_7952_(BlockState p_154170_, BlockGetter p_154171_, BlockPos p_154172_) {
        return Shapes.m_83040_();
    }

    @NotNull
    public VoxelShape m_5940_(BlockState p_154117_, BlockGetter p_154118_, BlockPos p_154119_, CollisionContext p_154120_) {
        DripstoneThickness dripstonethickness = (DripstoneThickness)p_154117_.m_61143_(THICKNESS);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (dripstonethickness == DripstoneThickness.TIP ? (p_154117_.m_61143_((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstonethickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (dripstonethickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3 vec3 = p_154117_.m_60824_(p_154118_, p_154119_);
        return voxelshape.m_83216_(vec3.f_82479_, 0.0, vec3.f_82481_);
    }

    public boolean m_180643_(BlockState p_181235_, BlockGetter p_181236_, BlockPos p_181237_) {
        return false;
    }

    public float m_142740_() {
        return 0.125f;
    }

    public void m_142525_(Level p_154059_, BlockPos p_154060_, FallingBlockEntity p_154061_) {
        if (!p_154061_.m_20067_()) {
            p_154059_.m_46796_(1045, p_154060_, 0);
        }
    }

    public DamageSource m_252932_(Entity p_254432_) {
        return p_254432_.m_269291_().m_269103_(p_254432_);
    }

    private static void spawnFallingStalactite(BlockState state, ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        BlockState blockstate = state;
        while (CrystallizedDripstoneBlock.isStalactite(blockstate)) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_((Level)level, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
            if (CrystallizedDripstoneBlock.isTip(blockstate, true)) {
                int i = Math.max(1 + pos.m_123342_() - blockpos$mutableblockpos.m_123342_(), 6);
                float f = 1.0f * (float)i;
                fallingblockentity.m_149656_(f, 40);
                break;
            }
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
            blockstate = level.m_8055_((BlockPos)blockpos$mutableblockpos);
        }
    }

    @VisibleForTesting
    public static void growStalactiteOrStalagmiteIfPossible(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState blockstate2;
        BlockPos blockpos;
        BlockState blockstate1;
        BlockState blockstate = level.m_8055_(pos.m_6630_(1));
        if (CrystallizedDripstoneBlock.canGrow(blockstate, blockstate1 = level.m_8055_(pos.m_6630_(2))) && (blockpos = CrystallizedDripstoneBlock.findTip(state, (LevelAccessor)level, pos, 7, false)) != null && CrystallizedDripstoneBlock.canDrip(blockstate2 = level.m_8055_(blockpos)) && CrystallizedDripstoneBlock.canTipGrow(blockstate2, level, blockpos)) {
            if (random.m_188499_()) {
                CrystallizedDripstoneBlock.grow(level, blockpos, Direction.DOWN);
            } else {
                CrystallizedDripstoneBlock.growStalagmiteBelow(level, blockpos);
            }
        }
    }

    private static void growStalagmiteBelow(ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        for (int i = 0; i < 10; ++i) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
            BlockState blockstate = level.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (!blockstate.m_60819_().m_76178_()) {
                return;
            }
            if (CrystallizedDripstoneBlock.isUnmergedTipWithDirection(blockstate, Direction.UP) && CrystallizedDripstoneBlock.canTipGrow(blockstate, level, (BlockPos)blockpos$mutableblockpos)) {
                CrystallizedDripstoneBlock.grow(level, (BlockPos)blockpos$mutableblockpos, Direction.UP);
                return;
            }
            if (!CrystallizedDripstoneBlock.isValidPointedDripstonePlacement((LevelReader)level, (BlockPos)blockpos$mutableblockpos, Direction.UP) || level.m_46801_(blockpos$mutableblockpos.m_7495_())) continue;
            CrystallizedDripstoneBlock.grow(level, blockpos$mutableblockpos.m_7495_(), Direction.UP);
            return;
        }
    }

    private static void grow(ServerLevel server, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.m_121945_(direction);
        BlockState blockstate = server.m_8055_(blockpos);
        if (CrystallizedDripstoneBlock.isUnmergedTipWithDirection(blockstate, direction.m_122424_())) {
            CrystallizedDripstoneBlock.createMergedTips(blockstate, (LevelAccessor)server, blockpos);
        } else if (blockstate.m_60795_() || blockstate.m_60713_(Blocks.f_49990_)) {
            CrystallizedDripstoneBlock.createDripstone((LevelAccessor)server, blockpos, direction, DripstoneThickness.TIP);
        }
    }

    private static void createDripstone(LevelAccessor level, BlockPos pos, Direction direction, DripstoneThickness thickness) {
        BlockState blockstate = (BlockState)((BlockState)((BlockState)((Block)JBlocks.POINTED_CRYSTALLIZED_DRIPSTONE.get()).m_49966_().m_61124_((Property)TIP_DIRECTION, (Comparable)direction)).m_61124_(THICKNESS, (Comparable)thickness)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
        level.m_7731_(pos, blockstate, 3);
    }

    private static void createMergedTips(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockPos blockpos;
        BlockPos blockpos1;
        if (state.m_61143_((Property)TIP_DIRECTION) == Direction.UP) {
            blockpos1 = pos;
            blockpos = pos.m_7494_();
        } else {
            blockpos = pos;
            blockpos1 = pos.m_7495_();
        }
        CrystallizedDripstoneBlock.createDripstone(level, blockpos, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        CrystallizedDripstoneBlock.createDripstone(level, blockpos1, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    @Nullable
    private static BlockPos findTip(BlockState state, LevelAccessor level, BlockPos pos, int maxIterations, boolean isTipMerge) {
        if (CrystallizedDripstoneBlock.isTip(state, isTipMerge)) {
            return pos;
        }
        Direction direction = (Direction)state.m_61143_((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202023_, p_202024_) -> p_202024_.m_60713_((Block)JBlocks.POINTED_CRYSTALLIZED_DRIPSTONE.get()) && p_202024_.m_61143_((Property)TIP_DIRECTION) == direction;
        return CrystallizedDripstoneBlock.findBlockVertical(level, pos, direction.m_122421_(), bipredicate, p_154168_ -> CrystallizedDripstoneBlock.isTip(p_154168_, isTipMerge), maxIterations).orElse(null);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader level, BlockPos pos, Direction dir) {
        Direction direction;
        if (CrystallizedDripstoneBlock.isValidPointedDripstonePlacement(level, pos, dir)) {
            direction = dir;
        } else {
            if (!CrystallizedDripstoneBlock.isValidPointedDripstonePlacement(level, pos, dir.m_122424_())) {
                return null;
            }
            direction = dir.m_122424_();
        }
        return direction;
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader level, BlockPos pos, Direction dir, boolean isTipMerge) {
        Direction direction = dir.m_122424_();
        BlockState blockstate = level.m_8055_(pos.m_121945_(dir));
        if (!CrystallizedDripstoneBlock.isPointedDripstoneWithDirection(blockstate, direction)) {
            if (!CrystallizedDripstoneBlock.isPointedDripstoneWithDirection(blockstate, dir)) {
                return DripstoneThickness.TIP;
            }
            DripstoneThickness dripstonethickness = (DripstoneThickness)blockstate.m_61143_(THICKNESS);
            if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
                BlockState blockstate1 = level.m_8055_(pos.m_121945_(direction));
                return !CrystallizedDripstoneBlock.isPointedDripstoneWithDirection(blockstate1, dir) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
            }
            return DripstoneThickness.FRUSTUM;
        }
        return !isTipMerge && blockstate.m_61143_(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
    }

    public static boolean canDrip(BlockState state) {
        return CrystallizedDripstoneBlock.isStalactite(state) && state.m_61143_(THICKNESS) == DripstoneThickness.TIP && (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    private static boolean canTipGrow(BlockState state, ServerLevel level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)TIP_DIRECTION);
        BlockPos blockpos = pos.m_121945_(direction);
        BlockState blockstate = level.m_8055_(blockpos);
        if (!blockstate.m_60819_().m_76178_()) {
            return false;
        }
        return blockstate.m_60795_() || CrystallizedDripstoneBlock.isUnmergedTipWithDirection(blockstate, direction.m_122424_());
    }

    private static boolean isValidPointedDripstonePlacement(LevelReader level, BlockPos pos, Direction dir) {
        BlockPos blockpos = pos.m_121945_(dir.m_122424_());
        BlockState blockstate = level.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)level, blockpos, dir) || CrystallizedDripstoneBlock.isPointedDripstoneWithDirection(blockstate, dir);
    }

    private static boolean isTip(BlockState state, boolean isTipMerge) {
        if (!state.m_60713_((Block)JBlocks.POINTED_CRYSTALLIZED_DRIPSTONE.get())) {
            return false;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)state.m_61143_(THICKNESS);
        return dripstonethickness == DripstoneThickness.TIP || isTipMerge && dripstonethickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(BlockState state, Direction dir) {
        return CrystallizedDripstoneBlock.isTip(state, false) && state.m_61143_((Property)TIP_DIRECTION) == dir;
    }

    private static boolean isStalactite(BlockState state) {
        return CrystallizedDripstoneBlock.isPointedDripstoneWithDirection(state, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState state) {
        return CrystallizedDripstoneBlock.isPointedDripstoneWithDirection(state, Direction.UP);
    }

    private static boolean isStalactiteStartPos(BlockState state, LevelReader level, BlockPos pos) {
        return CrystallizedDripstoneBlock.isStalactite(state) && !level.m_8055_(pos.m_7494_()).m_60713_((Block)JBlocks.POINTED_CRYSTALLIZED_DRIPSTONE.get());
    }

    protected boolean isPathfindable(@NotNull BlockState b, @NotNull PathComputationType p) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(BlockState state, Direction dir) {
        return state.m_60713_((Block)JBlocks.POINTED_CRYSTALLIZED_DRIPSTONE.get()) && state.m_61143_((Property)TIP_DIRECTION) == dir;
    }

    private static boolean canGrow(BlockState dripstoneState, BlockState state) {
        return dripstoneState.m_60713_((Block)JBlocks.CRYSTALLIZED_DRIPSTONE.get()) && state.m_60713_(Blocks.f_49990_) && state.m_60819_().m_76170_();
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor level, BlockPos pos, Direction.AxisDirection axis, BiPredicate<BlockPos, BlockState> positionalStatePredicate, Predicate<BlockState> statePredicate, int maxIterations) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)axis, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        for (int i = 1; i < maxIterations; ++i) {
            blockpos$mutableblockpos.m_122173_(direction);
            BlockState blockstate = level.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (statePredicate.test(blockstate)) {
                return Optional.of(blockpos$mutableblockpos.m_7949_());
            }
            if (!level.m_151562_(blockpos$mutableblockpos.m_123342_()) && positionalStatePredicate.test((BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }
}

