/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.jitl.common.block.entity.JChestBlockEntity;
import net.jitl.core.init.internal.JBlockEntities;
import net.jitl.core.init.internal.JBlockProperties;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class JChestBlock
extends AbstractChestBlock<JChestBlockEntity>
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<ChestType> TYPE = BlockStateProperties.f_61392_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape NORTHAABB = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SOUTHAABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
    protected static final VoxelShape WESTAABB = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape EASTAABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    protected static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    public static final BooleanProperty IS_LOCKED = BlockStateProperties.f_61444_;
    private static final DoubleBlockCombiner.Combiner<JChestBlockEntity, Optional<Container>> CHESTCOMBINER = new DoubleBlockCombiner.Combiner<JChestBlockEntity, Optional<Container>>(){

        @NotNull
        public Optional<Container> acceptDouble(JChestBlockEntity j, JChestBlockEntity j1) {
            return Optional.of(new CompoundContainer((Container)j, (Container)j1));
        }

        @NotNull
        public Optional<Container> acceptSingle(JChestBlockEntity j) {
            return Optional.of(j);
        }

        @NotNull
        public Optional<Container> acceptNone() {
            return Optional.empty();
        }
    };
    private static final DoubleBlockCombiner.Combiner<JChestBlockEntity, Optional<MenuProvider>> MENU_PROVIDER_COMBINER = new DoubleBlockCombiner.Combiner<JChestBlockEntity, Optional<MenuProvider>>(){

        @NotNull
        public Optional<MenuProvider> acceptDouble(final @NotNull JChestBlockEntity JChestBlockEntity3, final @NotNull JChestBlockEntity JChestBlockEntity4) {
            CompoundContainer container = new CompoundContainer((Container)JChestBlockEntity3, (Container)JChestBlockEntity4);
            return Optional.of(new MenuProvider(){
                final /* synthetic */ Container val$container;
                {
                    this.val$container = container;
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player player1) {
                    if (JChestBlockEntity3.m_7525_(player1) && JChestBlockEntity4.m_7525_(player1)) {
                        JChestBlockEntity3.m_59640_(inventory.f_35978_);
                        JChestBlockEntity4.m_59640_(inventory.f_35978_);
                        return ChestMenu.m_39246_((int)id, (Inventory)inventory, (Container)this.val$container);
                    }
                    return null;
                }

                @NotNull
                public Component m_5446_() {
                    if (JChestBlockEntity3.m_8077_()) {
                        return JChestBlockEntity3.m_5446_();
                    }
                    return JChestBlockEntity4.m_8077_() ? JChestBlockEntity4.m_5446_() : Component.m_237115_((String)"container.chestDouble");
                }
            });
        }

        @NotNull
        public Optional<MenuProvider> acceptSingle(JChestBlockEntity j) {
            return Optional.of(j);
        }

        @NotNull
        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };

    public JChestBlock() {
        super(JBlockProperties.CHEST, () -> JBlockEntities.JCHEST.get());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)ChestType.SINGLE)).m_61124_((Property)IS_LOCKED, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState state1) {
        ChestType chesttype = (ChestType)state1.m_61143_(TYPE);
        if (chesttype == ChestType.SINGLE) {
            return DoubleBlockCombiner.BlockType.SINGLE;
        }
        return chesttype == ChestType.RIGHT ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (facingState.m_60713_((Block)this) && facing.m_122434_().m_122479_()) {
            ChestType chesttype = (ChestType)facingState.m_61143_(TYPE);
            if (state.m_61143_(TYPE) == ChestType.SINGLE && chesttype != ChestType.SINGLE && state.m_61143_((Property)FACING) == facingState.m_61143_((Property)FACING) && JChestBlock.getConnectedDirection(facingState) == facing.m_122424_()) {
                return (BlockState)state.m_61124_(TYPE, (Comparable)chesttype.m_61486_());
            }
        } else if (JChestBlock.getConnectedDirection(state) == facing) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)ChestType.SINGLE);
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (state.m_61143_(TYPE) == ChestType.SINGLE) {
            return AABB;
        }
        return switch (JChestBlock.getConnectedDirection(state)) {
            case Direction.NORTH -> NORTHAABB;
            case Direction.SOUTH -> SOUTHAABB;
            case Direction.WEST -> WESTAABB;
            case Direction.EAST -> EASTAABB;
            default -> throw new IllegalStateException("Unexpected value: " + JChestBlock.getConnectedDirection(state));
        };
    }

    public static Direction getConnectedDirection(BlockState state2) {
        Direction direction = (Direction)state2.m_61143_((Property)FACING);
        return state2.m_61143_(TYPE) == ChestType.LEFT ? direction.m_122427_() : direction.m_122428_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction2;
        ChestType chesttype = ChestType.SINGLE;
        Direction direction = context.m_8125_().m_122424_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = context.m_7078_();
        Direction direction1 = context.m_43719_();
        if (direction1.m_122434_().m_122479_() && flag && (direction2 = this.candidatePartnerFacing(context, direction1.m_122424_())) != null && direction2.m_122434_() != direction1.m_122434_()) {
            direction = direction2;
            ChestType chestType = chesttype = direction2.m_122428_() == direction1.m_122424_() ? ChestType.RIGHT : ChestType.LEFT;
        }
        if (chesttype == ChestType.SINGLE && !flag) {
            if (direction == this.candidatePartnerFacing(context, direction.m_122427_())) {
                chesttype = ChestType.LEFT;
            } else if (direction == this.candidatePartnerFacing(context, direction.m_122428_())) {
                chesttype = ChestType.RIGHT;
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_(TYPE, (Comparable)chesttype)).m_61124_((Property)IS_LOCKED, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    private Direction candidatePartnerFacing(BlockPlaceContext context, Direction direction) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_().m_121945_(direction));
        return blockstate.m_60713_((Block)this) && blockstate.m_61143_(TYPE) == ChestType.SINGLE ? (Direction)blockstate.m_61143_((Property)FACING) : null;
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockentity;
        if (stack.m_41788_() && (blockentity = level.m_7702_(pos)) instanceof JChestBlockEntity) {
            ((JChestBlockEntity)blockentity).m_58638_(stack.m_41786_());
        }
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof Container) {
                if (!((Boolean)state.m_61143_((Property)IS_LOCKED)).booleanValue()) {
                    Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((Container)blockentity));
                }
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        Item heldItem = player.m_21205_().m_41720_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)IS_LOCKED)).booleanValue()) {
            player.m_213846_((Component)Component.m_237115_((String)"jitl.chest.locked"));
            return InteractionResult.FAIL;
        }
        if (!((Boolean)state.m_61143_((Property)IS_LOCKED)).booleanValue() && heldItem != JItems.PADLOCK.get()) {
            MenuProvider menuprovider = this.m_7246_(state, level, pos);
            if (menuprovider != null) {
                player.m_5893_(menuprovider);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public static Container getContainer(JChestBlock chest, BlockState state, Level level, BlockPos pos, boolean override) {
        return ((Optional)chest.m_5641_(state, level, pos, override).m_5649_(CHESTCOMBINER)).orElse(null);
    }

    @NotNull
    public DoubleBlockCombiner.NeighborCombineResult<? extends JChestBlockEntity> m_5641_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, boolean override) {
        BiPredicate<LevelAccessor, BlockPos> bipredicate = override ? (world, pos2) -> false : JChestBlock::isJChestBlockedAt;
        return DoubleBlockCombiner.m_52822_((BlockEntityType)((BlockEntityType)this.f_48675_.get()), JChestBlock::getBlockType, JChestBlock::getConnectedDirection, (DirectionProperty)FACING, (BlockState)state, (LevelAccessor)level, (BlockPos)pos, bipredicate);
    }

    @Nullable
    public MenuProvider m_7246_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        return ((Optional)this.m_5641_(state, level, pos, false).m_5649_(MENU_PROVIDER_COMBINER)).orElse(null);
    }

    public static DoubleBlockCombiner.Combiner<JChestBlockEntity, Float2FloatFunction> opennessCombiner(final LidBlockEntity lid) {
        return new DoubleBlockCombiner.Combiner<JChestBlockEntity, Float2FloatFunction>(){

            @NotNull
            public Float2FloatFunction acceptDouble(@NotNull JChestBlockEntity JChestBlockEntity8, @NotNull JChestBlockEntity JChestBlockEntity9) {
                return tickDelta -> Math.max(JChestBlockEntity8.m_6683_(tickDelta), JChestBlockEntity9.m_6683_(tickDelta));
            }

            @NotNull
            public Float2FloatFunction acceptSingle(@NotNull JChestBlockEntity JChestBlockEntity10) {
                return JChestBlockEntity10::m_6683_;
            }

            @NotNull
            public Float2FloatFunction acceptNone() {
                return arg_0 -> ((LidBlockEntity)lid).m_6683_(arg_0);
            }
        };
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new JChestBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? JChestBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)this.f_48675_.get()), JChestBlockEntity::lidAnimateTick) : null;
    }

    public static boolean isJChestBlockedAt(LevelAccessor level1, BlockPos pos1) {
        return JChestBlock.isBlockedChestByBlock((BlockGetter)level1, pos1) || JChestBlock.isCatSittingOnChest(level1, pos1);
    }

    private static boolean isBlockedChestByBlock(BlockGetter level, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        return level.m_8055_(blockpos).m_60796_(level, blockpos);
    }

    private static boolean isCatSittingOnChest(LevelAccessor level, BlockPos pos) {
        List list = level.m_45976_(Cat.class, new AABB((double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 2), (double)(pos.m_123343_() + 1)));
        if (!list.isEmpty()) {
            for (Cat cat : list) {
                if (!cat.m_21825_()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public int m_6782_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos pos) {
        return AbstractContainerMenu.m_38938_((Container)JChestBlock.getContainer(this, blockState, level, pos, false));
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        BlockState rotated = state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
        return mirror == Mirror.NONE ? rotated : (BlockState)rotated.m_61124_(TYPE, (Comparable)((ChestType)rotated.m_61143_(TYPE)).m_61486_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TYPE, WATERLOGGED, IS_LOCKED});
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return false;
    }

    public void m_213897_(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof JChestBlockEntity) {
            ((JChestBlockEntity)blockentity).m_155350_();
        }
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return (Boolean)state.m_61143_((Property)IS_LOCKED) != false ? 1000000.0f : super.getExplosionResistance(state, world, pos, explosion);
    }

    public float m_5880_(BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return (Boolean)state.m_61143_((Property)IS_LOCKED) != false ? 0.0f : super.m_5880_(state, player, level, pos);
    }
}

